/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.optimizing;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.amoro.api.BlockableOperation;
import org.apache.amoro.api.ServerTableIdentifier;
import org.apache.amoro.api.resource.ResourceGroup;
import org.apache.amoro.server.optimizing.OptimizingStatus;
import org.apache.amoro.server.table.TableRuntime;
import org.apache.amoro.shade.guava32.com.google.common.annotations.VisibleForTesting;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;

public class SchedulingPolicy {
    private static final String SCHEDULING_POLICY_PROPERTY_NAME = "scheduling-policy";
    private static final String QUOTA = "quota";
    private static final String BALANCED = "balanced";
    private final Map<ServerTableIdentifier, TableRuntime> tableRuntimeMap = new HashMap<ServerTableIdentifier, TableRuntime>();
    private volatile String policyName;
    private Comparator<TableRuntime> tableSorter;
    private final Lock tableLock = new ReentrantLock();

    public SchedulingPolicy(ResourceGroup group) {
        this.setTableSorterIfNeeded(group);
    }

    public void setTableSorterIfNeeded(ResourceGroup optimizerGroup) {
        block7: {
            this.tableLock.lock();
            try {
                this.policyName = Optional.ofNullable(optimizerGroup.getProperties()).orElseGet(Maps::newHashMap).getOrDefault(SCHEDULING_POLICY_PROPERTY_NAME, QUOTA);
                if (this.policyName.equalsIgnoreCase(QUOTA)) {
                    if (this.tableSorter == null || !(this.tableSorter instanceof QuotaOccupySorter)) {
                        this.tableSorter = new QuotaOccupySorter();
                    }
                    break block7;
                }
                if (this.policyName.equalsIgnoreCase(BALANCED)) {
                    if (this.tableSorter == null || !(this.tableSorter instanceof BalancedSorter)) {
                        this.tableSorter = new BalancedSorter();
                    }
                    break block7;
                }
                throw new IllegalArgumentException("Illegal scheduling policy: " + this.policyName);
            }
            finally {
                this.tableLock.unlock();
            }
        }
    }

    public String name() {
        return this.policyName;
    }

    public TableRuntime scheduleTable(Set<ServerTableIdentifier> skipSet) {
        this.tableLock.lock();
        try {
            this.fillSkipSet(skipSet);
            TableRuntime tableRuntime2 = this.tableRuntimeMap.values().stream().filter(tableRuntime -> !skipSet.contains(tableRuntime.getTableIdentifier())).min(this.tableSorter).orElse(null);
            return tableRuntime2;
        }
        finally {
            this.tableLock.unlock();
        }
    }

    public TableRuntime getTableRuntime(ServerTableIdentifier tableIdentifier) {
        this.tableLock.lock();
        try {
            TableRuntime tableRuntime = this.tableRuntimeMap.get(tableIdentifier);
            return tableRuntime;
        }
        finally {
            this.tableLock.unlock();
        }
    }

    private void fillSkipSet(Set<ServerTableIdentifier> originalSet) {
        long currentTime = System.currentTimeMillis();
        this.tableRuntimeMap.values().stream().filter(tableRuntime -> !this.isTablePending((TableRuntime)tableRuntime) || tableRuntime.isBlocked(BlockableOperation.OPTIMIZE) || currentTime - tableRuntime.getLastPlanTime() < tableRuntime.getOptimizingConfig().getMinPlanInterval()).forEach(tableRuntime -> originalSet.add(tableRuntime.getTableIdentifier()));
    }

    private boolean isTablePending(TableRuntime tableRuntime) {
        return tableRuntime.getOptimizingStatus() == OptimizingStatus.PENDING && (tableRuntime.getLastOptimizedSnapshotId() != tableRuntime.getCurrentSnapshotId() || tableRuntime.getLastOptimizedChangeSnapshotId() != tableRuntime.getCurrentChangeSnapshotId());
    }

    public void addTable(TableRuntime tableRuntime) {
        this.tableLock.lock();
        try {
            this.tableRuntimeMap.put(tableRuntime.getTableIdentifier(), tableRuntime);
        }
        finally {
            this.tableLock.unlock();
        }
    }

    public void removeTable(TableRuntime tableRuntime) {
        this.tableLock.lock();
        try {
            this.tableRuntimeMap.remove(tableRuntime.getTableIdentifier());
        }
        finally {
            this.tableLock.unlock();
        }
    }

    @VisibleForTesting
    Map<ServerTableIdentifier, TableRuntime> getTableRuntimeMap() {
        return this.tableRuntimeMap;
    }

    private static class BalancedSorter
    implements Comparator<TableRuntime> {
        private BalancedSorter() {
        }

        @Override
        public int compare(TableRuntime one, TableRuntime another) {
            return Long.compare(Math.max(one.getLastFullOptimizingTime(), Math.max(one.getLastMinorOptimizingTime(), one.getLastMajorOptimizingTime())), Math.max(another.getLastFullOptimizingTime(), Math.max(another.getLastMinorOptimizingTime(), another.getLastMajorOptimizingTime())));
        }
    }

    private static class QuotaOccupySorter
    implements Comparator<TableRuntime> {
        private final Map<TableRuntime, Double> tableWeightMap = Maps.newHashMap();

        private QuotaOccupySorter() {
        }

        @Override
        public int compare(TableRuntime one, TableRuntime another) {
            return Double.compare(this.tableWeightMap.computeIfAbsent(one, TableRuntime::calculateQuotaOccupy), this.tableWeightMap.computeIfAbsent(another, TableRuntime::calculateQuotaOccupy));
        }
    }
}

