/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.optimizing.maintainer;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Map;
import org.apache.amoro.api.config.TagConfiguration;
import org.apache.iceberg.ManageSnapshots;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoCreateIcebergTagAction {
    private static final Logger LOG = LoggerFactory.getLogger(AutoCreateIcebergTagAction.class);
    private final Table table;
    private final TagConfiguration tagConfig;
    private final LocalDateTime triggerTime;
    private final String tagName;

    public AutoCreateIcebergTagAction(Table table, TagConfiguration tagConfig, LocalDateTime checkTime) {
        this.table = table;
        this.tagConfig = tagConfig;
        LocalDateTime tagTime = tagConfig.getTriggerPeriod().getTagTime(checkTime, tagConfig.getTriggerOffsetMinutes());
        this.triggerTime = tagTime.plusMinutes(tagConfig.getTriggerOffsetMinutes());
        this.tagName = tagConfig.getTriggerPeriod().generateTagName(tagTime, tagConfig.getTagFormat());
    }

    public void execute() {
        if (!this.tagConfig.isAutoCreateTag()) {
            return;
        }
        LOG.debug("Start checking the automatic creation of tags for {}", (Object)this.table.name());
        if (this.tagExist()) {
            LOG.debug("Found the expected tag on {}, skip", (Object)this.table.name());
            return;
        }
        boolean success = this.createTag();
        if (success) {
            LOG.info("Created a tag successfully on {}", (Object)this.table.name());
        } else {
            LOG.info("Skipped tag creation on {}", (Object)this.table.name());
        }
    }

    private boolean tagExist() {
        String tag = this.table.refs().entrySet().stream().filter(entry -> ((SnapshotRef)entry.getValue()).isTag()).map(Map.Entry::getKey).filter(this.tagName::equals).findFirst().orElse(null);
        return tag != null;
    }

    private boolean createTag() {
        long tagTriggerTimestampMillis = this.getTagTriggerTimestampMillis();
        Snapshot snapshot = AutoCreateIcebergTagAction.findSnapshot(this.table, tagTriggerTimestampMillis);
        if (snapshot == null) {
            LOG.info("Found no snapshot at {} for {}", (Object)tagTriggerTimestampMillis, (Object)this.table.name());
            return false;
        }
        if (this.exceedMaxDelay(snapshot)) {
            LOG.info("{}'s snapshot {} at {} exceeds max delay {}, and the expected trigger time is {}", new Object[]{this.table.name(), snapshot.snapshotId(), snapshot.timestampMillis(), this.tagConfig.getMaxDelayMinutes(), tagTriggerTimestampMillis});
            return false;
        }
        ManageSnapshots tag = this.table.manageSnapshots().createTag(this.tagName, snapshot.snapshotId());
        if (this.tagConfig.getTagMaxAgeMs() > 0L) {
            tag.setMaxRefAgeMs(this.tagName, this.tagConfig.getTagMaxAgeMs());
        }
        tag.commit();
        LOG.info("Created a tag {} for {} on snapshot {} at {}", new Object[]{this.tagName, this.table.name(), snapshot.snapshotId(), snapshot.timestampMillis()});
        return true;
    }

    private boolean exceedMaxDelay(Snapshot snapshot) {
        if (this.tagConfig.getMaxDelayMinutes() <= 0) {
            return false;
        }
        long delay = snapshot.timestampMillis() - this.getTagTriggerTimestampMillis();
        return delay > (long)this.tagConfig.getMaxDelayMinutes() * 60000L;
    }

    private long getTagTriggerTimestampMillis() {
        return this.triggerTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    private static Snapshot findSnapshot(Table table, long tagTriggerTime) {
        Iterable snapshots = table.snapshots();
        for (Snapshot snapshot : snapshots) {
            long waterMark = AutoCreateIcebergTagAction.getWaterMark(table, snapshot);
            if (waterMark <= tagTriggerTime) continue;
            return snapshot;
        }
        return null;
    }

    private static long getWaterMark(Table table, Snapshot snapshot) {
        return snapshot.timestampMillis();
    }
}

