/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table.executor;

import java.time.Duration;
import org.apache.amoro.AmoroTable;
import org.apache.amoro.api.config.TableConfiguration;
import org.apache.amoro.server.optimizing.maintainer.TableMaintainer;
import org.apache.amoro.server.table.TableManager;
import org.apache.amoro.server.table.TableRuntime;
import org.apache.amoro.server.table.executor.BaseTableExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataExpiringExecutor
extends BaseTableExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(DataExpiringExecutor.class);
    private final Duration interval;

    protected DataExpiringExecutor(TableManager tableManager, int poolSize, Duration interval) {
        super(tableManager, poolSize);
        this.interval = interval;
    }

    @Override
    protected long getNextExecutingTime(TableRuntime tableRuntime) {
        return this.interval.toMillis();
    }

    @Override
    protected boolean enabled(TableRuntime tableRuntime) {
        return tableRuntime.getTableConfiguration().getExpiringDataConfig().isEnabled();
    }

    @Override
    public void handleConfigChanged(TableRuntime tableRuntime, TableConfiguration originalConfig) {
        this.scheduleIfNecessary(tableRuntime, this.getStartDelay());
    }

    @Override
    protected void execute(TableRuntime tableRuntime) {
        try {
            AmoroTable<?> amoroTable = this.loadTable(tableRuntime);
            TableMaintainer tableMaintainer = TableMaintainer.ofTable(amoroTable);
            tableMaintainer.expireData(tableRuntime);
        }
        catch (Throwable t) {
            LOG.error("unexpected expire error of table {} ", (Object)tableRuntime.getTableIdentifier(), (Object)t);
        }
    }
}

