/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table.internal;

import java.util.Map;
import org.apache.amoro.api.ServerTableIdentifier;
import org.apache.amoro.server.table.TableMetadata;
import org.apache.amoro.server.table.internal.IcebergInternalTableOperations;
import org.apache.iceberg.io.FileIO;

public class MixedIcebergInternalTableStoreOperations
extends IcebergInternalTableOperations {
    boolean forChangeStore;

    public MixedIcebergInternalTableStoreOperations(ServerTableIdentifier identifier, TableMetadata tableMetadata, FileIO io, boolean changeStore) {
        super(identifier, tableMetadata, io);
        this.forChangeStore = changeStore;
    }

    @Override
    protected String tableMetadataLocation(TableMetadata tableMeta) {
        if (this.forChangeStore) {
            return tableMeta.getProperties().get("change-store.iceberg.metadata.location");
        }
        return super.tableMetadataLocation(tableMeta);
    }

    @Override
    protected void updateMetadataLocationProperties(TableMetadata serverTableMetadata, String oldMetadataFileLocation, String newMetadataFileLocation) {
        if (!this.forChangeStore) {
            super.updateMetadataLocationProperties(serverTableMetadata, oldMetadataFileLocation, newMetadataFileLocation);
        } else {
            Map<String, String> properties = serverTableMetadata.getProperties();
            properties.put("change-store.iceberg.metadata.prev-location", oldMetadataFileLocation);
            properties.put("change-store.iceberg.metadata.location", newMetadataFileLocation);
            serverTableMetadata.setProperties(properties);
        }
    }
}

