/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.Descending$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.IcebergBucketTransform;
import org.apache.spark.sql.catalyst.expressions.IcebergDayTransform;
import org.apache.spark.sql.catalyst.expressions.IcebergHourTransform;
import org.apache.spark.sql.catalyst.expressions.IcebergMonthTransform;
import org.apache.spark.sql.catalyst.expressions.IcebergTruncateTransform;
import org.apache.spark.sql.catalyst.expressions.IcebergYearTransform;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NullOrdering;
import org.apache.spark.sql.catalyst.expressions.NullsFirst$;
import org.apache.spark.sql.catalyst.expressions.NullsLast$;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.expressions.BucketTransform$;
import org.apache.spark.sql.connector.expressions.DaysTransform$;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.HoursTransform$;
import org.apache.spark.sql.connector.expressions.IdentityTransform$;
import org.apache.spark.sql.connector.expressions.MonthsTransform$;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.SortValue$;
import org.apache.spark.sql.connector.expressions.TruncateTransform$;
import org.apache.spark.sql.connector.expressions.YearsTransform$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;

public final class ExtendedV2ExpressionUtils$
implements SQLConfHelper {
    public static ExtendedV2ExpressionUtils$ MODULE$;

    static {
        new ExtendedV2ExpressionUtils$();
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T extends NamedExpression> T resolveRef(NamedReference ref, LogicalPlan plan) {
        Option option = plan.resolve(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ref.fieldNames())).toSeq(), this.conf().resolver());
        if (option instanceof Some) {
            Some some = (Some)option;
            NamedExpression namedExpr = (NamedExpression)some.value();
            return (T)namedExpr;
        }
        if (None$.MODULE$.equals(option)) {
            String name = CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ref.fieldNames())).toSeq()).quoted();
            String outputString = ((TraversableOnce)plan.output().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Seq$.MODULE$.canBuildFrom())).mkString(",");
            throw QueryCompilationErrors$.MODULE$.cannotResolveAttributeError(name, outputString);
        }
        throw new MatchError((Object)option);
    }

    public <T extends NamedExpression> Seq<T> resolveRefs(Seq<NamedReference> refs, LogicalPlan plan) {
        return (Seq)refs.map((Function1 & Serializable & scala.Serializable)ref -> MODULE$.resolveRef((NamedReference)ref, plan), Seq$.MODULE$.canBuildFrom());
    }

    public Expression toCatalyst(org.apache.spark.sql.connector.expressions.Expression expr, LogicalPlan query) {
        org.apache.spark.sql.connector.expressions.Expression expression = expr;
        Option option = SortValue$.MODULE$.unapply(expression);
        if (!option.isEmpty()) {
            org.apache.spark.sql.connector.expressions.Expression child = (org.apache.spark.sql.connector.expressions.Expression)((Tuple3)option.get())._1();
            org.apache.spark.sql.connector.expressions.SortDirection direction = (org.apache.spark.sql.connector.expressions.SortDirection)((Tuple3)option.get())._2();
            org.apache.spark.sql.connector.expressions.NullOrdering nullOrdering = (org.apache.spark.sql.connector.expressions.NullOrdering)((Tuple3)option.get())._3();
            Expression catalystChild = this.toCatalyst(child, query);
            return new SortOrder(catalystChild, this.toCatalyst(direction), this.toCatalyst(nullOrdering), (Seq)Nil$.MODULE$);
        }
        Option option2 = IdentityTransform$.MODULE$.unapply(expression);
        if (!option2.isEmpty()) {
            FieldReference ref = (FieldReference)option2.get();
            return (Expression)this.resolveRef((NamedReference)ref, query);
        }
        Option option3 = BucketTransform$.MODULE$.unapply(expression);
        if (!option3.isEmpty()) {
            int numBuckets = ((Tuple2)option3.get())._1$mcI$sp();
            FieldReference ref = (FieldReference)((Tuple2)option3.get())._2();
            return new IcebergBucketTransform(numBuckets, (Expression)this.resolveRef((NamedReference)ref, query));
        }
        Option<Tuple2<Object, FieldReference>> option4 = TruncateTransform$.MODULE$.unapply(expression);
        if (!option4.isEmpty()) {
            int length = ((Tuple2)option4.get())._1$mcI$sp();
            FieldReference ref = (FieldReference)((Tuple2)option4.get())._2();
            return new IcebergTruncateTransform((Expression)this.resolveRef((NamedReference)ref, query), length);
        }
        Option option5 = YearsTransform$.MODULE$.unapply(expression);
        if (!option5.isEmpty()) {
            FieldReference ref = (FieldReference)option5.get();
            return new IcebergYearTransform((Expression)this.resolveRef((NamedReference)ref, query));
        }
        Option option6 = MonthsTransform$.MODULE$.unapply(expression);
        if (!option6.isEmpty()) {
            FieldReference ref = (FieldReference)option6.get();
            return new IcebergMonthTransform((Expression)this.resolveRef((NamedReference)ref, query));
        }
        Option option7 = DaysTransform$.MODULE$.unapply(expression);
        if (!option7.isEmpty()) {
            FieldReference ref = (FieldReference)option7.get();
            return new IcebergDayTransform((Expression)this.resolveRef((NamedReference)ref, query));
        }
        Option option8 = HoursTransform$.MODULE$.unapply(expression);
        if (!option8.isEmpty()) {
            FieldReference ref = (FieldReference)option8.get();
            return new IcebergHourTransform((Expression)this.resolveRef((NamedReference)ref, query));
        }
        if (expression instanceof FieldReference) {
            FieldReference fieldReference = (FieldReference)expression;
            return (Expression)this.resolveRef((NamedReference)fieldReference, query);
        }
        throw new AnalysisException(new StringBuilder(27).append(expr).append(" is not currently supported").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    private SortDirection toCatalyst(org.apache.spark.sql.connector.expressions.SortDirection direction) {
        org.apache.spark.sql.connector.expressions.SortDirection sortDirection = direction;
        if (org.apache.spark.sql.connector.expressions.SortDirection.ASCENDING.equals(sortDirection)) {
            return Ascending$.MODULE$;
        }
        if (org.apache.spark.sql.connector.expressions.SortDirection.DESCENDING.equals(sortDirection)) {
            return Descending$.MODULE$;
        }
        throw new MatchError((Object)sortDirection);
    }

    private NullOrdering toCatalyst(org.apache.spark.sql.connector.expressions.NullOrdering nullOrdering) {
        org.apache.spark.sql.connector.expressions.NullOrdering nullOrdering2 = nullOrdering;
        if (org.apache.spark.sql.connector.expressions.NullOrdering.NULLS_FIRST.equals(nullOrdering2)) {
            return NullsFirst$.MODULE$;
        }
        if (org.apache.spark.sql.connector.expressions.NullOrdering.NULLS_LAST.equals(nullOrdering2)) {
            return NullsLast$.MODULE$;
        }
        throw new MatchError((Object)nullOrdering2);
    }

    private ExtendedV2ExpressionUtils$() {
        MODULE$ = this;
        SQLConfHelper.$init$((SQLConfHelper)this);
    }
}

