/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.hive.op;

import java.util.List;
import java.util.Set;
import org.apache.amoro.hive.HMSClientPool;
import org.apache.amoro.hive.op.UpdateHiveFiles;
import org.apache.amoro.hive.table.UnkeyedHiveTable;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.Transaction;

public class RewriteHiveFiles
extends UpdateHiveFiles<RewriteFiles>
implements RewriteFiles {
    public RewriteHiveFiles(Transaction transaction, boolean insideTransaction, UnkeyedHiveTable table, HMSClientPool hmsClient, HMSClientPool transactionClient) {
        super(transaction, insideTransaction, table, transaction.newRewrite(), hmsClient, transactionClient);
    }

    @Deprecated
    public RewriteFiles rewriteFiles(Set<DataFile> filesToDelete, Set<DataFile> filesToAdd) {
        filesToDelete.forEach(this::deleteFile);
        filesToAdd.forEach(this::addFile);
        return this;
    }

    @Deprecated
    public RewriteFiles rewriteFiles(Set<DataFile> filesToDelete, Set<DataFile> filesToAdd, long sequenceNumber) {
        ((RewriteFiles)this.delegate).dataSequenceNumber(sequenceNumber);
        filesToDelete.forEach(arg_0 -> ((RewriteFiles)((RewriteFiles)this.delegate)).deleteFile(arg_0));
        filesToAdd.stream().filter(dataFile -> !this.isHiveDataFile((DataFile)dataFile)).forEach(arg_0 -> ((RewriteFiles)((RewriteFiles)this.delegate)).addFile(arg_0));
        this.markHiveFiles(filesToDelete, filesToAdd);
        return this;
    }

    public RewriteFiles rewriteFiles(Set<DataFile> dataFilesToReplace, Set<DeleteFile> deleteFilesToReplace, Set<DataFile> dataFilesToAdd, Set<DeleteFile> deleteFilesToAdd) {
        dataFilesToReplace.forEach(this::deleteFile);
        deleteFilesToReplace.forEach(this::deleteFile);
        dataFilesToAdd.forEach(this::addFile);
        deleteFilesToAdd.forEach(this::addFile);
        return this;
    }

    public RewriteFiles deleteFile(DataFile dataFile) {
        ((RewriteFiles)this.delegate).deleteFile(dataFile);
        this.markDeletedHiveFile(dataFile);
        return this;
    }

    public RewriteFiles deleteFile(DeleteFile deleteFile) {
        ((RewriteFiles)this.delegate).deleteFile(deleteFile);
        return this;
    }

    public RewriteFiles addFile(DataFile dataFile) {
        if (this.isHiveDataFile(dataFile)) {
            this.markAddedHiveFile(dataFile);
        } else {
            ((RewriteFiles)this.delegate).addFile(dataFile);
        }
        return this;
    }

    public RewriteFiles addFile(DeleteFile deleteFile) {
        ((RewriteFiles)this.delegate).addFile(deleteFile);
        return this;
    }

    public RewriteFiles dataSequenceNumber(long sequenceNumber) {
        ((RewriteFiles)this.delegate).dataSequenceNumber(sequenceNumber);
        return this;
    }

    private void markAddedHiveFile(DataFile dataFile) {
        if (this.isHiveDataFile(dataFile)) {
            this.addFiles.add(dataFile);
        }
    }

    private void markDeletedHiveFile(DataFile dataFile) {
        if (this.isHiveDataFile(dataFile)) {
            this.deleteFiles.add(dataFile);
        }
    }

    private void markHiveFiles(Set<DataFile> filesToDelete, Set<DataFile> filesToAdd) {
        filesToAdd.forEach(this::markAddedHiveFile);
        filesToDelete.forEach(this::markDeletedHiveFile);
    }

    public RewriteFiles validateFromSnapshot(long snapshotId) {
        ((RewriteFiles)this.delegate).validateFromSnapshot(snapshotId);
        return this;
    }

    @Override
    protected void postHiveDataCommitted(List<DataFile> committedDataFile) {
        committedDataFile.forEach(arg_0 -> ((RewriteFiles)((RewriteFiles)this.delegate)).addFile(arg_0));
    }

    @Override
    protected RewriteFiles self() {
        return this;
    }
}

