/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.util.Preconditions;

public class JarListInfo
implements ResponseBody {
    public static final String JAR_LIST_FIELD_ADDRESS = "address";
    public static final String JAR_LIST_FIELD_FILES = "files";
    @JsonProperty(value="address")
    private String address;
    @JsonProperty(value="files")
    public List<JarFileInfo> jarFileList;

    @JsonCreator
    public JarListInfo(@JsonProperty(value="address") String address, @JsonProperty(value="files") List<JarFileInfo> jarFileList) {
        this.address = (String)Preconditions.checkNotNull((Object)address);
        this.jarFileList = (List)Preconditions.checkNotNull(jarFileList);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.jarFileList);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || this.getClass() != o.getClass()) {
            return false;
        }
        JarListInfo that = (JarListInfo)o;
        return Objects.equals(this.address, that.address) && Objects.equals(this.jarFileList, that.jarFileList);
    }

    public static class JarEntryInfo {
        public static final String JAR_ENTRY_FIELD_NAME = "name";
        public static final String JAR_ENTRY_FIELD_DESC = "description";
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        @Nullable
        private String description;

        @JsonCreator
        public JarEntryInfo(@JsonProperty(value="name") String name, @JsonProperty(value="description") @Nullable String description) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.description = description;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.description);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (null == o || this.getClass() != o.getClass()) {
                return false;
            }
            JarEntryInfo that = (JarEntryInfo)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description);
        }
    }

    public static class JarFileInfo {
        public static final String JAR_FILE_FIELD_ID = "id";
        public static final String JAR_FILE_FIELD_NAME = "name";
        public static final String JAR_FILE_FIELD_UPLOADED = "uploaded";
        public static final String JAR_FILE_FIELD_ENTRY = "entry";
        @JsonProperty(value="id")
        public String id;
        @JsonProperty(value="name")
        public String name;
        @JsonProperty(value="uploaded")
        private long uploaded;
        @JsonProperty(value="entry")
        private List<JarEntryInfo> jarEntryList;

        @JsonCreator
        public JarFileInfo(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="uploaded") long uploaded, @JsonProperty(value="entry") List<JarEntryInfo> jarEntryList) {
            this.id = (String)Preconditions.checkNotNull((Object)id);
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.uploaded = uploaded;
            this.jarEntryList = (List)Preconditions.checkNotNull(jarEntryList);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this.uploaded, this.jarEntryList);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (null == o || this.getClass() != o.getClass()) {
                return false;
            }
            JarFileInfo that = (JarFileInfo)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && this.uploaded == that.uploaded && Objects.equals(this.jarEntryList, that.jarEntryList);
        }
    }
}

