/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.filter;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricType;
import org.apache.flink.runtime.metrics.filter.MetricFilter;

public class DefaultMetricFilter
implements MetricFilter {
    private static final EnumSet<MetricType> ALL_METRIC_TYPES = EnumSet.allOf(MetricType.class);
    @VisibleForTesting
    static final String LIST_DELIMITER = ",";
    private final List<FilterSpec> includes;
    private final List<FilterSpec> excludes;

    private DefaultMetricFilter(List<FilterSpec> includes, List<FilterSpec> excludes) {
        this.includes = includes;
        this.excludes = excludes;
    }

    @Override
    public boolean filter(Metric metric, String name, String logicalScope) {
        for (FilterSpec exclude : this.excludes) {
            if (!exclude.namePattern.matcher(name).matches() || !exclude.scopePattern.matcher(logicalScope).matches() || !exclude.types.contains(metric.getMetricType())) continue;
            return false;
        }
        for (FilterSpec include : this.includes) {
            if (!include.namePattern.matcher(name).matches() || !include.scopePattern.matcher(logicalScope).matches() || !include.types.contains(metric.getMetricType())) continue;
            return true;
        }
        return false;
    }

    public static MetricFilter fromConfiguration(Configuration configuration) {
        List includes = (List)configuration.get(MetricOptions.REPORTER_INCLUDES);
        List excludes = (List)configuration.get(MetricOptions.REPORTER_EXCLUDES);
        List<FilterSpec> includeFilters = includes.stream().map(i -> DefaultMetricFilter.parse(i)).collect(Collectors.toList());
        List<FilterSpec> excludeFilters = excludes.stream().map(e -> DefaultMetricFilter.parse(e)).collect(Collectors.toList());
        return new DefaultMetricFilter(includeFilters, excludeFilters);
    }

    private static FilterSpec parse(String filter) {
        String[] split = filter.split(":");
        Pattern scope = DefaultMetricFilter.convertToPattern(split[0]);
        Pattern name = split.length > 1 ? DefaultMetricFilter.convertToPattern(split[1]) : DefaultMetricFilter.convertToPattern("*");
        EnumSet<MetricType> type = split.length > 2 ? DefaultMetricFilter.parseMetricTypes(split[2]) : ALL_METRIC_TYPES;
        return new FilterSpec(scope, name, type);
    }

    @VisibleForTesting
    static Pattern convertToPattern(String scopeOrNameComponent) {
        String[] split = scopeOrNameComponent.split(LIST_DELIMITER);
        String rawPattern = Arrays.stream(split).map(s -> s.replaceAll("\\.", "\\.")).map(s -> s.replaceAll("\\*", ".*")).collect(Collectors.joining("|", "(", ")"));
        return Pattern.compile(rawPattern);
    }

    @VisibleForTesting
    static EnumSet<MetricType> parseMetricTypes(String typeComponent) {
        String[] split = typeComponent.split(LIST_DELIMITER);
        if (split.length == 1 && split[0].equals("*")) {
            return ALL_METRIC_TYPES;
        }
        return EnumSet.copyOf(Arrays.stream(split).map(s -> (MetricType)ConfigurationUtils.convertToEnum((Object)s, MetricType.class)).collect(Collectors.toSet()));
    }

    private static class FilterSpec {
        private final Pattern scopePattern;
        private final Pattern namePattern;
        private final EnumSet<MetricType> types;

        private FilterSpec(Pattern scopePattern, Pattern namePattern, EnumSet<MetricType> types) {
            this.scopePattern = scopePattern;
            this.namePattern = namePattern;
            this.types = types;
        }
    }
}

