/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.arrow.vectorized;

import java.util.Arrays;

public class NullabilityHolder {
    private final byte[] isNull;
    private int numNulls;
    private final byte[] nonNulls;
    private final byte[] nulls;

    public NullabilityHolder(int size) {
        this.isNull = new byte[size];
        this.nonNulls = new byte[size];
        Arrays.fill(this.nonNulls, (byte)0);
        this.nulls = new byte[size];
        Arrays.fill(this.nulls, (byte)1);
    }

    public int size() {
        return this.isNull.length;
    }

    public void setNull(int index) {
        this.isNull[index] = 1;
        ++this.numNulls;
    }

    public void setNotNull(int index) {
        this.isNull[index] = 0;
    }

    public void setNulls(int startIndex, int num) {
        System.arraycopy(this.nulls, 0, this.isNull, startIndex, num);
        this.numNulls += num;
    }

    public void setNotNulls(int startIndex, int num) {
        System.arraycopy(this.nonNulls, 0, this.isNull, startIndex, num);
    }

    public byte isNullAt(int index) {
        return this.isNull[index];
    }

    public boolean hasNulls() {
        return this.numNulls > 0;
    }

    public int numNulls() {
        return this.numNulls;
    }

    public void reset() {
        this.numNulls = 0;
    }
}

