/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.io.reader;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.io.reader.CombinedDeleteFilter;
import org.apache.amoro.io.reader.DataReaderCommon;
import org.apache.amoro.io.reader.StructForDelete;
import org.apache.amoro.optimizing.OptimizingDataReader;
import org.apache.amoro.optimizing.RewriteFilesInput;
import org.apache.amoro.shade.guava32.com.google.common.annotations.VisibleForTesting;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.utils.map.StructLikeCollections;
import org.apache.avro.Schema;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.avro.DataReader;
import org.apache.iceberg.data.orc.GenericOrcReader;
import org.apache.iceberg.data.parquet.GenericParquetReaders;
import org.apache.iceberg.encryption.EncryptedFiles;
import org.apache.iceberg.encryption.EncryptedInputFile;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.orc.TypeDescription;
import org.apache.parquet.schema.MessageType;

public class GenericCombinedIcebergDataReader
implements OptimizingDataReader {
    protected final org.apache.iceberg.Schema tableSchema;
    protected final String nameMapping;
    protected final boolean caseSensitive;
    protected final AuthenticatedFileIO fileIO;
    protected final EncryptionManager encryptionManager;
    protected final BiFunction<Type, Object, Object> convertConstant;
    protected final boolean reuseContainer;
    protected CombinedDeleteFilter<Record> deleteFilter;
    protected PartitionSpec spec;
    protected RewriteFilesInput input;

    public GenericCombinedIcebergDataReader(AuthenticatedFileIO fileIO, org.apache.iceberg.Schema tableSchema, PartitionSpec spec, EncryptionManager encryptionManager, String nameMapping, boolean caseSensitive, BiFunction<Type, Object, Object> convertConstant, boolean reuseContainer, StructLikeCollections structLikeCollections, RewriteFilesInput rewriteFilesInput) {
        this.tableSchema = tableSchema;
        this.spec = spec;
        this.encryptionManager = encryptionManager;
        this.nameMapping = nameMapping;
        this.caseSensitive = caseSensitive;
        this.fileIO = fileIO;
        this.convertConstant = convertConstant;
        this.reuseContainer = reuseContainer;
        this.input = rewriteFilesInput;
        this.deleteFilter = new GenericDeleteFilter(rewriteFilesInput, tableSchema, structLikeCollections);
    }

    @Override
    public CloseableIterable<Record> readData() {
        if (this.input.rewrittenDataFiles() == null) {
            return CloseableIterable.empty();
        }
        org.apache.iceberg.Schema requireSchema = GenericCombinedIcebergDataReader.fileProjection(this.tableSchema, this.tableSchema, this.deleteFilter.hasPosition(), this.deleteFilter.deleteIds());
        CloseableIterable concat = CloseableIterable.concat((Iterable)CloseableIterable.transform((CloseableIterable)CloseableIterable.withNoopClose((Iterable)Arrays.stream(this.input.rewrittenDataFiles()).collect(Collectors.toList())), s -> this.openFile((DataFile)s, this.spec, requireSchema)));
        StructForDelete structForDelete = new StructForDelete(requireSchema, this.deleteFilter.deleteIds());
        CloseableIterable structForDeleteCloseableIterable = CloseableIterable.transform((CloseableIterable)concat, structForDelete::wrap);
        CloseableIterable iterable = CloseableIterable.transform(this.deleteFilter.filter((CloseableIterable<StructForDelete<Record>>)structForDeleteCloseableIterable), StructForDelete::recover);
        return iterable;
    }

    @Override
    public CloseableIterable<Record> readDeletedData() {
        if (this.input.rePosDeletedDataFiles() == null) {
            return CloseableIterable.empty();
        }
        org.apache.iceberg.Schema schema = new org.apache.iceberg.Schema(new Types.NestedField[]{MetadataColumns.FILE_PATH, MetadataColumns.ROW_POSITION, org.apache.amoro.table.MetadataColumns.TREE_NODE_FIELD});
        org.apache.iceberg.Schema requireSchema = GenericCombinedIcebergDataReader.fileProjection(this.tableSchema, schema, this.deleteFilter.hasPosition(), this.deleteFilter.deleteIds());
        CloseableIterable concat = CloseableIterable.concat((Iterable)CloseableIterable.transform((CloseableIterable)CloseableIterable.withNoopClose((Iterable)Arrays.stream(this.input.rePosDeletedDataFiles()).collect(Collectors.toList())), s -> this.openFile((DataFile)s, this.spec, requireSchema)));
        StructForDelete structForDelete = new StructForDelete(requireSchema, this.deleteFilter.deleteIds());
        CloseableIterable structForDeleteCloseableIterable = CloseableIterable.transform((CloseableIterable)concat, structForDelete::wrap);
        CloseableIterable iterable = CloseableIterable.transform(this.deleteFilter.filterNegate((CloseableIterable<StructForDelete<Record>>)structForDeleteCloseableIterable), StructForDelete::recover);
        return iterable;
    }

    @Override
    public void close() {
        this.deleteFilter.close();
    }

    private CloseableIterable<Record> openFile(DataFile dataFile, PartitionSpec spec, org.apache.iceberg.Schema require) {
        Map<Integer, ?> idToConstant = DataReaderCommon.getIdToConstant(dataFile, require, spec, this.convertConstant);
        return this.openFile(dataFile, require, idToConstant);
    }

    private CloseableIterable<Record> openFile(DataFile dataFile, org.apache.iceberg.Schema fileProjection, Map<Integer, ?> idToConstant) {
        EncryptedInputFile encryptedInput = EncryptedFiles.encryptedInput((InputFile)this.fileIO.newInputFile(dataFile.path().toString()), (ByteBuffer)dataFile.keyMetadata());
        InputFile input = this.encryptionManager.decrypt(encryptedInput);
        switch (dataFile.format()) {
            case AVRO: {
                Avro.ReadBuilder avro = Avro.read((InputFile)input).project(fileProjection).createReaderFunc(avroSchema -> DataReader.create((org.apache.iceberg.Schema)fileProjection, (Schema)avroSchema, (Map)idToConstant));
                if (this.reuseContainer) {
                    avro.reuseContainers();
                }
                return avro.build();
            }
            case PARQUET: {
                Parquet.ReadBuilder parquet = Parquet.read((InputFile)input).project(fileProjection).createReaderFunc(fileSchema -> GenericParquetReaders.buildReader((org.apache.iceberg.Schema)fileProjection, (MessageType)fileSchema, (Map)idToConstant));
                if (this.reuseContainer) {
                    parquet.reuseContainers();
                }
                return parquet.build();
            }
            case ORC: {
                org.apache.iceberg.Schema projectionWithoutConstantAndMetadataFields = TypeUtil.selectNot((org.apache.iceberg.Schema)fileProjection, (Set)Sets.union(idToConstant.keySet(), (Set)MetadataColumns.metadataFieldIds()));
                ORC.ReadBuilder orc = ORC.read((InputFile)input).project(projectionWithoutConstantAndMetadataFields).createReaderFunc(fileSchema -> GenericOrcReader.buildReader((org.apache.iceberg.Schema)fileProjection, (TypeDescription)fileSchema, (Map)idToConstant));
                return orc.build();
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot read %s file: %s", dataFile.format().name(), dataFile.path()));
    }

    private static org.apache.iceberg.Schema fileProjection(org.apache.iceberg.Schema tableSchema, org.apache.iceberg.Schema requestedSchema, boolean hasPosDelete, Set<Integer> eqDeleteIds) {
        if (!hasPosDelete && eqDeleteIds == null) {
            return requestedSchema;
        }
        List requiredEqDeleteIds = TypeUtil.select((org.apache.iceberg.Schema)tableSchema, eqDeleteIds).columns().stream().map(Types.NestedField::fieldId).collect(Collectors.toList());
        LinkedHashSet requiredIds = Sets.newLinkedHashSet();
        if (hasPosDelete) {
            requiredIds.add(MetadataColumns.FILE_PATH.fieldId());
            requiredIds.add(MetadataColumns.ROW_POSITION.fieldId());
        }
        requiredIds.addAll(requiredEqDeleteIds);
        requiredIds.add(org.apache.amoro.table.MetadataColumns.TRANSACTION_ID_FILED.fieldId());
        requiredIds.add(MetadataColumns.IS_DELETED.fieldId());
        LinkedHashSet missingIds = Sets.newLinkedHashSet((Iterable)Sets.difference((Set)requiredIds, (Set)TypeUtil.getProjectedIds((org.apache.iceberg.Schema)requestedSchema)));
        if (missingIds.isEmpty()) {
            return requestedSchema;
        }
        ArrayList columns = Lists.newArrayList((Iterable)requestedSchema.columns());
        Iterator iterator = missingIds.iterator();
        while (iterator.hasNext()) {
            int fieldId = (Integer)iterator.next();
            if (fieldId == MetadataColumns.ROW_POSITION.fieldId() || fieldId == MetadataColumns.IS_DELETED.fieldId() || fieldId == org.apache.amoro.table.MetadataColumns.TRANSACTION_ID_FILED.fieldId() || fieldId == MetadataColumns.FILE_PATH.fieldId()) continue;
            Types.NestedField field = tableSchema.asStruct().field(fieldId);
            Preconditions.checkArgument((field != null ? 1 : 0) != 0, (String)"Cannot find required field for ID %s", (int)fieldId);
            columns.add(field);
        }
        if (missingIds.contains(MetadataColumns.FILE_PATH.fieldId())) {
            columns.add(MetadataColumns.FILE_PATH);
        }
        if (missingIds.contains(MetadataColumns.ROW_POSITION.fieldId())) {
            columns.add(MetadataColumns.ROW_POSITION);
        }
        if (missingIds.contains(org.apache.amoro.table.MetadataColumns.TRANSACTION_ID_FILED.fieldId())) {
            columns.add(org.apache.amoro.table.MetadataColumns.TRANSACTION_ID_FILED);
        }
        if (missingIds.contains(MetadataColumns.IS_DELETED.fieldId())) {
            columns.add(MetadataColumns.IS_DELETED);
        }
        return new org.apache.iceberg.Schema((List)columns);
    }

    @VisibleForTesting
    public CombinedDeleteFilter<Record> getDeleteFilter() {
        return this.deleteFilter;
    }

    protected class GenericDeleteFilter
    extends CombinedDeleteFilter<Record> {
        public GenericDeleteFilter(RewriteFilesInput rewriteFilesInput, org.apache.iceberg.Schema tableSchema, StructLikeCollections structLikeCollections) {
            super(rewriteFilesInput, tableSchema, structLikeCollections);
        }

        @Override
        protected InputFile getInputFile(ContentFile<?> contentFile) {
            EncryptedInputFile encryptedInput = EncryptedFiles.encryptedInput((InputFile)GenericCombinedIcebergDataReader.this.fileIO.newInputFile(contentFile.path().toString()), (ByteBuffer)contentFile.keyMetadata());
            return GenericCombinedIcebergDataReader.this.encryptionManager.decrypt(encryptedInput);
        }

        @Override
        protected AuthenticatedFileIO getFileIO() {
            return GenericCombinedIcebergDataReader.this.fileIO;
        }
    }
}

