/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.mixed;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.amoro.PooledAmsClient;
import org.apache.amoro.TableFormat;
import org.apache.amoro.api.AmoroTableMetastore;
import org.apache.amoro.api.CatalogMeta;
import org.apache.amoro.api.NoSuchObjectException;
import org.apache.amoro.client.AmsClientPools;
import org.apache.amoro.client.AmsThriftUrl;
import org.apache.amoro.mixed.BasicMixedIcebergCatalog;
import org.apache.amoro.mixed.InternalMixedIcebergCatalog;
import org.apache.amoro.mixed.MixedFormatCatalog;
import org.apache.amoro.shade.guava32.com.google.common.annotations.VisibleForTesting;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.shade.thrift.org.apache.thrift.TException;
import org.apache.amoro.table.TableMetaStore;
import org.apache.amoro.utils.MixedCatalogUtil;
import org.apache.iceberg.common.DynConstructors;

public class CatalogLoader {
    public static final String INTERNAL_CATALOG_IMPL = InternalMixedIcebergCatalog.class.getName();
    public static final String HIVE_CATALOG_IMPL = "org.apache.amoro.hive.catalog.MixedHiveCatalog";
    public static final String MIXED_ICEBERG_CATALOG_IMP = BasicMixedIcebergCatalog.class.getName();

    public static MixedFormatCatalog load(String catalogUrl, Map<String, String> properties) {
        AmsThriftUrl url = AmsThriftUrl.parse(catalogUrl, "TableMetastore");
        if (url.catalogName() == null || url.catalogName().contains("/")) {
            throw new IllegalArgumentException("invalid catalog name " + url.catalogName());
        }
        return CatalogLoader.loadCatalog(catalogUrl, url.catalogName(), properties);
    }

    public static MixedFormatCatalog load(String catalogUrl) {
        return CatalogLoader.load(catalogUrl, Maps.newHashMap());
    }

    private static String catalogImpl(String metastoreType, Map<String, String> catalogProperties) {
        String catalogImpl;
        Set<TableFormat> tableFormats = MixedCatalogUtil.tableFormats(metastoreType, catalogProperties);
        Preconditions.checkArgument((tableFormats.size() == 1 ? 1 : 0) != 0, (Object)"Catalog support only one table format now.");
        TableFormat tableFormat = tableFormats.iterator().next();
        Preconditions.checkArgument((TableFormat.MIXED_HIVE == tableFormat || TableFormat.MIXED_ICEBERG == tableFormat ? 1 : 0) != 0, (String)"MixedCatalogLoader only support mixed-format, format: %s", (Object)tableFormat.name());
        switch (metastoreType) {
            case "hadoop": 
            case "glue": 
            case "custom": {
                Preconditions.checkArgument((TableFormat.MIXED_ICEBERG == tableFormat ? 1 : 0) != 0, (String)"%s catalog support mixed-iceberg table only.", (Object)metastoreType);
                catalogImpl = MIXED_ICEBERG_CATALOG_IMP;
                break;
            }
            case "hive": {
                if (TableFormat.MIXED_HIVE == tableFormat) {
                    catalogImpl = HIVE_CATALOG_IMPL;
                    break;
                }
                catalogImpl = MIXED_ICEBERG_CATALOG_IMP;
                break;
            }
            case "ams": {
                if (TableFormat.MIXED_ICEBERG == tableFormat) {
                    catalogImpl = INTERNAL_CATALOG_IMPL;
                    break;
                }
                throw new IllegalArgumentException("Internal Catalog mixed-iceberg table only");
            }
            default: {
                throw new IllegalStateException("unsupported metastore type:" + metastoreType);
            }
        }
        return catalogImpl;
    }

    public static CatalogMeta loadMeta(String catalogUrl) {
        AmsThriftUrl url = AmsThriftUrl.parse(catalogUrl, "TableMetastore");
        if (url.catalogName() == null || url.catalogName().contains("/")) {
            throw new IllegalArgumentException("invalid catalog name " + url.catalogName());
        }
        PooledAmsClient client = new PooledAmsClient(catalogUrl);
        try {
            return client.getCatalog(url.catalogName());
        }
        catch (TException e) {
            throw new IllegalStateException("failed when load catalog " + url.catalogName(), e);
        }
    }

    public static List<String> catalogs(String metastoreUrl) {
        try {
            return ((AmoroTableMetastore.Iface)AmsClientPools.getClientPool(metastoreUrl).iface()).getCatalogs().stream().map(CatalogMeta::getCatalogName).collect(Collectors.toList());
        }
        catch (TException e) {
            throw new IllegalStateException("failed when load catalogs", e);
        }
    }

    private static MixedFormatCatalog loadCatalog(String metaStoreUrl, String catalogName, Map<String, String> properties) {
        PooledAmsClient client = new PooledAmsClient(metaStoreUrl);
        try {
            CatalogMeta catalogMeta = client.getCatalog(catalogName);
            String type = catalogMeta.getCatalogType();
            catalogMeta.putToCatalogProperties("ams.uri", metaStoreUrl);
            MixedCatalogUtil.mergeCatalogProperties(catalogMeta, properties);
            return CatalogLoader.createCatalog(catalogName, type, catalogMeta.getCatalogProperties(), MixedCatalogUtil.buildMetaStore(catalogMeta));
        }
        catch (NoSuchObjectException e1) {
            throw new IllegalArgumentException("catalog not found, please check catalog name", (Throwable)((Object)e1));
        }
        catch (Exception e) {
            throw new IllegalStateException("failed when load catalog " + catalogName, e);
        }
    }

    public static MixedFormatCatalog createCatalog(String catalogName, String metastoreType, Map<String, String> properties, TableMetaStore metaStore) {
        String catalogImpl = CatalogLoader.catalogImpl(metastoreType, properties);
        properties = MixedCatalogUtil.withIcebergCatalogInitializeProperties(catalogName, metastoreType, properties);
        MixedFormatCatalog catalog = CatalogLoader.buildCatalog(catalogImpl);
        catalog.initialize(catalogName, properties, metaStore);
        return catalog;
    }

    @VisibleForTesting
    public static MixedFormatCatalog createCatalog(String catalogName, String catalogImpl, String metastoreType, Map<String, String> properties, TableMetaStore metaStore) {
        properties = MixedCatalogUtil.withIcebergCatalogInitializeProperties(catalogName, metastoreType, properties);
        MixedFormatCatalog catalog = CatalogLoader.buildCatalog(catalogImpl);
        catalog.initialize(catalogName, properties, metaStore);
        return catalog;
    }

    private static MixedFormatCatalog buildCatalog(String impl) {
        DynConstructors.Ctor ctor;
        try {
            ctor = DynConstructors.builder(MixedFormatCatalog.class).impl(impl, new Class[0]).buildChecked();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize Catalog implementation %s: %s", impl, e.getMessage()), e);
        }
        try {
            return (MixedFormatCatalog)ctor.newInstance(new Object[0]);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize Catalog, %s does not implement Catalog.", impl), e);
        }
    }
}

