/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.mixed;

import java.util.HashMap;
import java.util.Map;
import org.apache.amoro.TableFormat;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.io.AuthenticatedFileIOs;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.table.BasicKeyedTable;
import org.apache.amoro.table.BasicUnkeyedTable;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.amoro.table.TableMetaStore;
import org.apache.amoro.table.UnkeyedTable;
import org.apache.amoro.utils.MixedCatalogUtil;
import org.apache.amoro.utils.TablePropertyUtil;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixedTables {
    private static final Logger LOG = LoggerFactory.getLogger(MixedTables.class);
    protected TableMetaStore tableMetaStore;
    protected Catalog icebergCatalog;
    protected Map<String, String> catalogProperties;

    public MixedTables(TableMetaStore tableMetaStore, Map<String, String> catalogProperties, Catalog catalog) {
        this.tableMetaStore = tableMetaStore;
        this.icebergCatalog = catalog;
        this.catalogProperties = catalogProperties;
    }

    public boolean isBaseStore(Table table) {
        return TablePropertyUtil.isBaseStore(table.properties(), TableFormat.MIXED_ICEBERG);
    }

    public TableIdentifier parseChangeIdentifier(Table base) {
        return TablePropertyUtil.parseChangeIdentifier(base.properties());
    }

    protected TableIdentifier generateChangeStoreIdentifier(TableIdentifier baseIdentifier) {
        String separator = this.catalogProperties.getOrDefault("mixed-format.table-store.separator", "_");
        return TableIdentifier.of((Namespace)baseIdentifier.namespace(), (String)(baseIdentifier.name() + separator + "change" + separator));
    }

    public MixedTable loadTable(Table base, org.apache.amoro.table.TableIdentifier tableIdentifier) {
        AuthenticatedFileIO io = AuthenticatedFileIOs.buildAdaptIcebergFileIO(this.tableMetaStore, base.io());
        PrimaryKeySpec keySpec = TablePropertyUtil.parsePrimaryKeySpec(base.schema(), base.properties());
        if (!keySpec.primaryKeyExisted()) {
            return new BasicUnkeyedTable(tableIdentifier, this.useMixedTableOperation(base, io), io, this.catalogProperties);
        }
        Table changeIcebergTable = this.loadChangeStore(base);
        BasicKeyedTable.BaseInternalTable baseStore = new BasicKeyedTable.BaseInternalTable(tableIdentifier, this.useMixedTableOperation(base, io), io, this.catalogProperties);
        BasicKeyedTable.ChangeInternalTable changeStore = new BasicKeyedTable.ChangeInternalTable(tableIdentifier, this.useMixedTableOperation(changeIcebergTable, io), io, this.catalogProperties);
        return new BasicKeyedTable(keySpec, baseStore, changeStore);
    }

    public MixedTable createTable(org.apache.amoro.table.TableIdentifier identifier, Schema schema, PartitionSpec partitionSpec, PrimaryKeySpec keySpec, Map<String, String> properties) {
        TableIdentifier baseIdentifier = TableIdentifier.of((String[])new String[]{identifier.getDatabase(), identifier.getTableName()});
        TableIdentifier changeIdentifier = this.generateChangeStoreIdentifier(baseIdentifier);
        Table base = this.createBaseStore(baseIdentifier, schema, partitionSpec, keySpec, properties);
        AuthenticatedFileIO io = AuthenticatedFileIOs.buildAdaptIcebergFileIO(this.tableMetaStore, base.io());
        if (!keySpec.primaryKeyExisted()) {
            return new BasicUnkeyedTable(identifier, this.useMixedTableOperation(base, io), io, this.catalogProperties);
        }
        Table change = this.createChangeStore(baseIdentifier, changeIdentifier, schema, partitionSpec, keySpec, properties);
        BasicKeyedTable.BaseInternalTable baseStore = new BasicKeyedTable.BaseInternalTable(identifier, this.useMixedTableOperation(base, io), io, this.catalogProperties);
        BasicKeyedTable.ChangeInternalTable changeStore = new BasicKeyedTable.ChangeInternalTable(identifier, this.useMixedTableOperation(change, io), io, this.catalogProperties);
        return new BasicKeyedTable(keySpec, baseStore, changeStore);
    }

    protected Table createBaseStore(TableIdentifier baseIdentifier, Schema schema, PartitionSpec partitionSpec, PrimaryKeySpec keySpec, Map<String, String> properties) {
        TableIdentifier changeIdentifier = this.generateChangeStoreIdentifier(baseIdentifier);
        if (keySpec.primaryKeyExisted() && this.tableStoreExists(changeIdentifier)) {
            throw new AlreadyExistsException("change store already exists", new Object[0]);
        }
        HashMap baseProperties = Maps.newHashMap(properties);
        baseProperties.putAll(TablePropertyUtil.baseStoreProperties(keySpec, changeIdentifier, TableFormat.MIXED_ICEBERG));
        Catalog.TableBuilder baseBuilder = this.icebergCatalog.buildTable(baseIdentifier, schema).withPartitionSpec(partitionSpec).withProperties((Map)baseProperties);
        return baseBuilder.create();
    }

    protected Table createChangeStore(TableIdentifier baseIdentifier, TableIdentifier changeIdentifier, Schema schema, PartitionSpec partitionSpec, PrimaryKeySpec keySpec, Map<String, String> properties) {
        HashMap changeProperties = Maps.newHashMap(properties);
        changeProperties.putAll(TablePropertyUtil.changeStoreProperties(keySpec, TableFormat.MIXED_ICEBERG));
        Catalog.TableBuilder changeBuilder = this.icebergCatalog.buildTable(changeIdentifier, schema).withProperties((Map)changeProperties).withPartitionSpec(partitionSpec);
        try {
            Table change = this.tableMetaStore.doAs(() -> ((Catalog.TableBuilder)changeBuilder).create());
            return change;
        }
        catch (RuntimeException e) {
            LOG.warn("Create base store failed for reason: {}", (Object)e.getMessage());
            this.tableMetaStore.doAs(() -> this.icebergCatalog.dropTable(baseIdentifier, true));
            throw e;
        }
    }

    public boolean dropTable(MixedTable table, boolean purge) {
        UnkeyedTable base = table.isKeyedTable() ? table.asKeyedTable().baseTable() : table.asUnkeyedTable();
        boolean deleted = this.dropBaseStore(TableIdentifier.of((String[])new String[]{base.id().getDatabase(), base.id().getTableName()}), purge);
        boolean changeDeleted = false;
        if (table.isKeyedTable()) {
            try {
                changeDeleted = this.dropChangeStore(this.parseChangeIdentifier(base.asUnkeyedTable()), purge);
                return deleted && changeDeleted;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return deleted;
    }

    protected boolean dropBaseStore(TableIdentifier tableStoreIdentifier, boolean purge) {
        return this.tableMetaStore.doAs(() -> this.icebergCatalog.dropTable(tableStoreIdentifier, purge));
    }

    protected boolean dropChangeStore(TableIdentifier changStoreIdentifier, boolean purge) {
        return this.tableMetaStore.doAs(() -> this.icebergCatalog.dropTable(changStoreIdentifier, purge));
    }

    private Table loadChangeStore(Table base) {
        TableIdentifier changeIdentifier = this.parseChangeIdentifier(base);
        return this.tableMetaStore.doAs(() -> this.icebergCatalog.loadTable(changeIdentifier));
    }

    private boolean tableStoreExists(TableIdentifier identifier) {
        return this.tableMetaStore.doAs(() -> this.icebergCatalog.tableExists(identifier));
    }

    private Table useMixedTableOperation(Table table, AuthenticatedFileIO io) {
        return MixedCatalogUtil.useMixedTableOperations(table, table.location(), io, this.tableMetaStore.getConfiguration());
    }
}

