/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.io.Serializable;
import org.apache.iceberg.spark.SparkTypeToType;
import org.apache.iceberg.spark.SparkValueConverter;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Type;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.api.java.UDF1;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;

public class IcebergSpark {
    private IcebergSpark() {
    }

    public static void registerBucketUDF(SparkSession session, String funcName, DataType sourceType, int numBuckets) {
        SparkTypeToType typeConverter = new SparkTypeToType();
        Type sourceIcebergType = typeConverter.atomic(sourceType);
        Transform bucket = Transforms.bucket((Type)sourceIcebergType, (int)numBuckets);
        session.udf().register(funcName, (UDF1 & Serializable)value -> (Integer)bucket.apply(SparkValueConverter.convert(sourceIcebergType, value)), DataTypes.IntegerType);
    }

    public static void registerTruncateUDF(SparkSession session, String funcName, DataType sourceType, int width) {
        SparkTypeToType typeConverter = new SparkTypeToType();
        Type sourceIcebergType = typeConverter.atomic(sourceType);
        Transform truncate = Transforms.truncate((Type)sourceIcebergType, (int)width);
        session.udf().register(funcName, (UDF1 & Serializable)value -> truncate.apply(SparkValueConverter.convert(sourceIcebergType, value)), sourceType);
    }
}

