/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Splitter;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.SparkTableCache;
import org.apache.iceberg.spark.source.SparkTable;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public class SparkCachedTableCatalog
implements TableCatalog {
    private static final String CLASS_NAME = SparkCachedTableCatalog.class.getName();
    private static final Splitter COMMA = Splitter.on((String)",");
    private static final Pattern AT_TIMESTAMP = Pattern.compile("at_timestamp_(\\d+)");
    private static final Pattern SNAPSHOT_ID = Pattern.compile("snapshot_id_(\\d+)");
    private static final SparkTableCache TABLE_CACHE = SparkTableCache.get();
    private String name = null;

    public Identifier[] listTables(String[] namespace) {
        throw new UnsupportedOperationException(CLASS_NAME + " does not support listing tables");
    }

    public SparkTable loadTable(Identifier ident) throws NoSuchTableException {
        Pair<Table, Long> table = this.load(ident);
        return new SparkTable((Table)table.first(), (Long)table.second(), false);
    }

    public void invalidateTable(Identifier ident) {
        throw new UnsupportedOperationException(CLASS_NAME + " does not support table invalidation");
    }

    public SparkTable createTable(Identifier ident, StructType schema, Transform[] partitions, Map<String, String> properties) throws TableAlreadyExistsException {
        throw new UnsupportedOperationException(CLASS_NAME + " does not support creating tables");
    }

    public SparkTable alterTable(Identifier ident, TableChange ... changes) {
        throw new UnsupportedOperationException(CLASS_NAME + " does not support altering tables");
    }

    public boolean dropTable(Identifier ident) {
        throw new UnsupportedOperationException(CLASS_NAME + " does not support dropping tables");
    }

    public boolean purgeTable(Identifier ident) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(CLASS_NAME + " does not support purging tables");
    }

    public void renameTable(Identifier oldIdent, Identifier newIdent) {
        throw new UnsupportedOperationException(CLASS_NAME + " does not support renaming tables");
    }

    public void initialize(String catalogName, CaseInsensitiveStringMap options) {
        this.name = catalogName;
    }

    public String name() {
        return this.name;
    }

    private Pair<Table, Long> load(Identifier ident) throws NoSuchTableException {
        Preconditions.checkArgument((ident.namespace().length == 0 ? 1 : 0) != 0, (Object)(CLASS_NAME + " does not support namespaces"));
        Pair<String, List<String>> parsedIdent = this.parseIdent(ident);
        String key = (String)parsedIdent.first();
        List metadata = (List)parsedIdent.second();
        Long asOfTimestamp = null;
        Long snapshotId = null;
        for (String meta : metadata) {
            Matcher timeBasedMatcher = AT_TIMESTAMP.matcher(meta);
            if (timeBasedMatcher.matches()) {
                asOfTimestamp = Long.parseLong(timeBasedMatcher.group(1));
                continue;
            }
            Matcher snapshotBasedMatcher = SNAPSHOT_ID.matcher(meta);
            if (!snapshotBasedMatcher.matches()) continue;
            snapshotId = Long.parseLong(snapshotBasedMatcher.group(1));
        }
        Preconditions.checkArgument((asOfTimestamp == null || snapshotId == null ? 1 : 0) != 0, (String)"Cannot specify both snapshot and timestamp for time travel: %s", (Object)ident);
        Table table = TABLE_CACHE.get(key);
        if (table == null) {
            throw new NoSuchTableException(ident);
        }
        if (snapshotId != null) {
            return Pair.of((Object)table, snapshotId);
        }
        if (asOfTimestamp != null) {
            return Pair.of((Object)table, (Object)SnapshotUtil.snapshotIdAsOfTime((Table)table, (long)asOfTimestamp));
        }
        return Pair.of((Object)table, null);
    }

    private Pair<String, List<String>> parseIdent(Identifier ident) {
        int hashIndex = ident.name().lastIndexOf(35);
        if (hashIndex != -1 && !ident.name().endsWith("#")) {
            String key = ident.name().substring(0, hashIndex);
            List metadata = COMMA.splitToList((CharSequence)ident.name().substring(hashIndex + 1));
            return Pair.of((Object)key, (Object)metadata);
        }
        return Pair.of((Object)ident.name(), (Object)ImmutableList.of());
    }
}

