/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DistributionMode;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Table;
import org.apache.iceberg.actions.BinPackStrategy;
import org.apache.iceberg.spark.FileRewriteCoordinator;
import org.apache.iceberg.spark.FileScanTaskSetManager;
import org.apache.iceberg.spark.SparkTableCache;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;

public class SparkBinPackStrategy
extends BinPackStrategy {
    private final Table table;
    private final SparkSession spark;
    private final SparkTableCache tableCache = SparkTableCache.get();
    private final FileScanTaskSetManager manager = FileScanTaskSetManager.get();
    private final FileRewriteCoordinator rewriteCoordinator = FileRewriteCoordinator.get();

    public SparkBinPackStrategy(Table table, SparkSession spark) {
        this.table = table;
        this.spark = spark;
    }

    public Table table() {
        return this.table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DataFile> rewriteFiles(List<FileScanTask> filesToRewrite) {
        String groupID = UUID.randomUUID().toString();
        try {
            this.tableCache.add(groupID, this.table);
            this.manager.stageTasks(this.table, groupID, filesToRewrite);
            Dataset scanDF = this.spark.read().format("iceberg").option("file-scan-task-set-id", groupID).option("split-size", this.splitSize(this.inputFileSize(filesToRewrite))).option("file-open-cost", "0").load(groupID);
            boolean requiresRepartition = !filesToRewrite.get(0).spec().equals((Object)this.table.spec());
            String distributionMode = requiresRepartition ? DistributionMode.RANGE.modeName() : DistributionMode.NONE.modeName();
            scanDF.write().format("iceberg").option("rewritten-file-scan-task-set-id", groupID).option("target-file-size-bytes", this.writeMaxFileSize()).option("distribution-mode", distributionMode).mode("append").save(groupID);
            Set<DataFile> set = this.rewriteCoordinator.fetchNewDataFiles(this.table, groupID);
            return set;
        }
        finally {
            this.tableCache.remove(groupID);
            this.manager.removeTasks(this.table, groupID);
            this.rewriteCoordinator.clearRewrite(this.table, groupID);
        }
    }
}

