/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.api.config;

import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;

public class ConfigOption<T> {
    static final String EMPTY_DESCRIPTION = "";
    private final String key;
    private final T defaultValue;
    private final String description;
    private final Class<?> clazz;
    private final boolean isList;

    ConfigOption(String key, Class<?> clazz, String description, T defaultValue, boolean isList) {
        this.key = (String)Preconditions.checkNotNull((Object)key);
        this.description = description;
        this.defaultValue = defaultValue;
        this.clazz = (Class)Preconditions.checkNotNull(clazz);
        this.isList = isList;
    }

    Class<?> getClazz() {
        return this.clazz;
    }

    boolean isList() {
        return this.isList;
    }

    public ConfigOption<T> withDescription(String description) {
        return new ConfigOption<T>(this.key, this.clazz, description, this.defaultValue, this.isList);
    }

    public String key() {
        return this.key;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public T defaultValue() {
        return this.defaultValue;
    }

    public String description() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && o.getClass() == ConfigOption.class) {
            ConfigOption that = (ConfigOption)o;
            return this.key.equals(that.key) && (this.defaultValue == null ? that.defaultValue == null : that.defaultValue != null && this.defaultValue.equals(that.defaultValue));
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.key.hashCode() + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
    }

    public String toString() {
        return String.format("Key: '%s' , default: %s", this.key, this.defaultValue);
    }
}

