/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.api.process;

import org.apache.amoro.api.TableRuntime;
import org.apache.amoro.api.process.AmoroProcess;
import org.apache.amoro.api.process.ProcessStatus;
import org.apache.amoro.api.process.SimpleFuture;
import org.apache.amoro.api.process.TableProcessState;

public abstract class TableProcess<T extends TableProcessState>
implements AmoroProcess<T> {
    protected final T state;
    protected final TableRuntime tableRuntime;
    private final SimpleFuture submitFuture = new SimpleFuture();
    private final SimpleFuture completeFuture = new SimpleFuture();
    private volatile ProcessStatus status = ProcessStatus.ACTIVE;
    private volatile String failedReason;

    protected TableProcess(T state, TableRuntime tableRuntime) {
        this.state = state;
        this.tableRuntime = tableRuntime;
        this.completeFuture.whenCompleted(() -> {
            if (this.status == ProcessStatus.FAILED) {
                state.setFailedReason(this.failedReason);
            } else {
                state.setStatus(this.status);
            }
        });
    }

    protected void completeSubmitting() {
        this.submitFuture.complete();
    }

    protected void complete() {
        this.status = ProcessStatus.SUCCESS;
        this.completeFuture.complete();
    }

    protected void complete(String errorMessage) {
        this.status = ProcessStatus.FAILED;
        this.failedReason = errorMessage;
        this.completeFuture.complete();
    }

    public TableRuntime getTableRuntime() {
        return this.tableRuntime;
    }

    @Override
    public T getState() {
        return this.state;
    }

    @Override
    public void close() {
        this.closeInternal();
        this.status = ProcessStatus.CLOSED;
        this.completeFuture.complete();
    }

    @Override
    public ProcessStatus getStatus() {
        return this.status;
    }

    protected abstract void closeInternal();

    @Override
    public SimpleFuture getSubmitFuture() {
        return this.submitFuture.anyOf(this.completeFuture);
    }

    @Override
    public SimpleFuture getCompleteFuture() {
        return this.completeFuture;
    }
}

