/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.partition.BufferWithChannel;
import org.apache.flink.runtime.io.network.partition.DataBuffer;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageSubpartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.BufferAccumulator;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemoryManager;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageSortBuffer;
import org.apache.flink.util.Preconditions;

public class SortBufferAccumulator
implements BufferAccumulator {
    private final int numSubpartitions;
    private final int numBuffers;
    private final int bufferSizeBytes;
    private final LinkedList<MemorySegment> freeSegments = new LinkedList();
    private final TieredStorageMemoryManager memoryManager;
    @Nullable
    private DataBuffer currentDataBuffer;
    @Nullable
    private BufferRecycler bufferRecycler;
    @Nullable
    private BiConsumer<TieredStorageSubpartitionId, List<Buffer>> accumulatedBufferFlusher;
    private boolean isBroadcastDataBuffer;

    public SortBufferAccumulator(int numSubpartitions, int numBuffers, int bufferSizeBytes, TieredStorageMemoryManager memoryManager) {
        this.numSubpartitions = numSubpartitions;
        this.bufferSizeBytes = bufferSizeBytes;
        this.numBuffers = numBuffers;
        this.memoryManager = memoryManager;
    }

    @Override
    public void setup(BiConsumer<TieredStorageSubpartitionId, List<Buffer>> bufferFlusher) {
        this.accumulatedBufferFlusher = bufferFlusher;
    }

    @Override
    public void receive(ByteBuffer record, TieredStorageSubpartitionId subpartitionId, Buffer.DataType dataType, boolean isBroadcast) throws IOException {
        int targetSubpartition = subpartitionId.getSubpartitionId();
        this.switchCurrentDataBufferIfNeeded(isBroadcast);
        if (!((DataBuffer)Preconditions.checkNotNull((Object)this.currentDataBuffer)).append(record, targetSubpartition, dataType)) {
            return;
        }
        if (!this.currentDataBuffer.hasRemaining()) {
            this.currentDataBuffer.release();
            this.writeLargeRecord(record, targetSubpartition, dataType);
            return;
        }
        this.flushDataBuffer();
        Preconditions.checkState((boolean)record.hasRemaining(), (Object)"Empty record.");
        this.receive(record, subpartitionId, dataType, isBroadcast);
    }

    @Override
    public void close() {
        this.flushCurrentDataBuffer();
        this.releaseFreeBuffers();
        if (this.currentDataBuffer != null) {
            this.currentDataBuffer.release();
        }
    }

    private void switchCurrentDataBufferIfNeeded(boolean isBroadcast) {
        if (isBroadcast == this.isBroadcastDataBuffer && this.currentDataBuffer != null && !this.currentDataBuffer.isReleased() && !this.currentDataBuffer.isFinished()) {
            return;
        }
        this.isBroadcastDataBuffer = isBroadcast;
        this.flushCurrentDataBuffer();
        this.currentDataBuffer = this.createNewDataBuffer();
    }

    private DataBuffer createNewDataBuffer() {
        this.requestBuffers();
        int numBuffersForSort = this.freeSegments.size() / 2;
        return new TieredStorageSortBuffer(this.freeSegments, this::recycleBuffer, this.numSubpartitions, this.bufferSizeBytes, numBuffersForSort);
    }

    private void requestBuffers() {
        while (this.freeSegments.size() < this.numBuffers) {
            Buffer buffer = this.requestBuffer();
            this.freeSegments.add(((Buffer)Preconditions.checkNotNull((Object)buffer)).getMemorySegment());
            if (this.bufferRecycler != null) continue;
            this.bufferRecycler = buffer.getRecycler();
        }
    }

    private void flushDataBuffer() {
        MemorySegment freeSegment;
        BufferWithChannel bufferWithChannel;
        if (this.currentDataBuffer == null || this.currentDataBuffer.isReleased() || !this.currentDataBuffer.hasRemaining()) {
            return;
        }
        this.currentDataBuffer.finish();
        while ((bufferWithChannel = this.currentDataBuffer.getNextBuffer(freeSegment = this.getFreeSegment())) != null) {
            this.flushBuffer(bufferWithChannel);
        }
        this.releaseFreeBuffers();
        this.currentDataBuffer.release();
    }

    private void flushCurrentDataBuffer() {
        if (this.currentDataBuffer != null) {
            this.flushDataBuffer();
            this.currentDataBuffer = null;
        }
    }

    private void writeLargeRecord(ByteBuffer record, int subpartitionId, Buffer.DataType dataType) {
        Preconditions.checkState((dataType != Buffer.DataType.EVENT_BUFFER ? 1 : 0) != 0);
        while (record.hasRemaining()) {
            int toCopy = Math.min(record.remaining(), this.bufferSizeBytes);
            MemorySegment writeBuffer = this.requestBuffer().getMemorySegment();
            writeBuffer.put(0, record, toCopy);
            this.flushBuffer(new BufferWithChannel(new NetworkBuffer(writeBuffer, (BufferRecycler)Preconditions.checkNotNull((Object)this.bufferRecycler), dataType, toCopy), subpartitionId));
        }
        this.releaseFreeBuffers();
    }

    private MemorySegment getFreeSegment() {
        MemorySegment freeSegment = this.freeSegments.poll();
        if (freeSegment == null) {
            freeSegment = this.requestBuffer().getMemorySegment();
        }
        return freeSegment;
    }

    private void flushBuffer(BufferWithChannel bufferWithChannel) {
        ((BiConsumer)Preconditions.checkNotNull(this.accumulatedBufferFlusher)).accept(new TieredStorageSubpartitionId(bufferWithChannel.getChannelIndex()), Collections.singletonList(bufferWithChannel.getBuffer()));
    }

    private Buffer requestBuffer() {
        BufferBuilder bufferBuilder = this.memoryManager.requestBufferBlocking(this);
        BufferConsumer bufferConsumer = bufferBuilder.createBufferConsumerFromBeginning();
        Buffer buffer = bufferConsumer.build();
        bufferBuilder.close();
        bufferConsumer.close();
        return buffer;
    }

    private void releaseFreeBuffers() {
        this.freeSegments.forEach(this::recycleBuffer);
        this.freeSegments.clear();
    }

    private void recycleBuffer(MemorySegment memorySegment) {
        ((BufferRecycler)Preconditions.checkNotNull((Object)this.bufferRecycler)).recycle(memorySegment);
    }
}

