/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.Utils;
import org.apache.flink.api.java.io.CsvInputFormat;
import org.apache.flink.api.java.io.PojoCsvInputFormat;
import org.apache.flink.api.java.io.TupleCsvInputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple10;
import org.apache.flink.api.java.tuple.Tuple11;
import org.apache.flink.api.java.tuple.Tuple12;
import org.apache.flink.api.java.tuple.Tuple13;
import org.apache.flink.api.java.tuple.Tuple14;
import org.apache.flink.api.java.tuple.Tuple15;
import org.apache.flink.api.java.tuple.Tuple16;
import org.apache.flink.api.java.tuple.Tuple17;
import org.apache.flink.api.java.tuple.Tuple18;
import org.apache.flink.api.java.tuple.Tuple19;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple20;
import org.apache.flink.api.java.tuple.Tuple21;
import org.apache.flink.api.java.tuple.Tuple22;
import org.apache.flink.api.java.tuple.Tuple23;
import org.apache.flink.api.java.tuple.Tuple24;
import org.apache.flink.api.java.tuple.Tuple25;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.tuple.Tuple6;
import org.apache.flink.api.java.tuple.Tuple7;
import org.apache.flink.api.java.tuple.Tuple8;
import org.apache.flink.api.java.tuple.Tuple9;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.core.fs.Path;
import org.apache.flink.util.Preconditions;

@Deprecated
@Public
public class CsvReader {
    private final Path path;
    private final ExecutionEnvironment executionContext;
    protected boolean[] includedMask;
    protected String lineDelimiter = "\n";
    protected String fieldDelimiter = ",";
    protected String commentPrefix = null;
    protected boolean parseQuotedStrings = false;
    protected char quoteCharacter = (char)34;
    protected boolean skipFirstLineAsHeader = false;
    protected boolean ignoreInvalidLines = false;
    private String charset = "UTF-8";

    public CsvReader(Path filePath, ExecutionEnvironment executionContext) {
        Preconditions.checkNotNull((Object)filePath, (String)"The file path may not be null.");
        Preconditions.checkNotNull((Object)executionContext, (String)"The execution context may not be null.");
        this.path = filePath;
        this.executionContext = executionContext;
    }

    public CsvReader(String filePath, ExecutionEnvironment executionContext) {
        this(new Path((String)Preconditions.checkNotNull((Object)filePath, (String)"The file path may not be null.")), executionContext);
    }

    public Path getFilePath() {
        return this.path;
    }

    public CsvReader lineDelimiter(String delimiter) {
        if (delimiter == null || delimiter.length() == 0) {
            throw new IllegalArgumentException("The delimiter must not be null or an empty string");
        }
        this.lineDelimiter = delimiter;
        return this;
    }

    @Deprecated
    @PublicEvolving
    public CsvReader fieldDelimiter(char delimiter) {
        this.fieldDelimiter = String.valueOf(delimiter);
        return this;
    }

    public CsvReader fieldDelimiter(String delimiter) {
        this.fieldDelimiter = delimiter;
        return this;
    }

    public CsvReader parseQuotedStrings(char quoteCharacter) {
        this.parseQuotedStrings = true;
        this.quoteCharacter = quoteCharacter;
        return this;
    }

    public CsvReader ignoreComments(String commentPrefix) {
        if (commentPrefix == null || commentPrefix.length() == 0) {
            throw new IllegalArgumentException("The comment prefix must not be null or an empty string");
        }
        this.commentPrefix = commentPrefix;
        return this;
    }

    @PublicEvolving
    public String getCharset() {
        return this.charset;
    }

    @PublicEvolving
    public void setCharset(String charset) {
        this.charset = (String)Preconditions.checkNotNull((Object)charset);
    }

    public CsvReader includeFields(boolean ... fields) {
        if (fields == null || fields.length == 0) {
            throw new IllegalArgumentException("The set of included fields must not be null or empty.");
        }
        int lastTruePos = -1;
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i]) continue;
            lastTruePos = i;
        }
        if (lastTruePos == -1) {
            throw new IllegalArgumentException("The description of fields to parse excluded all fields. At least one fields must be included.");
        }
        this.includedMask = lastTruePos == fields.length - 1 ? fields : Arrays.copyOfRange(fields, 0, lastTruePos + 1);
        return this;
    }

    public CsvReader includeFields(String mask) {
        boolean[] includedMask = new boolean[mask.length()];
        for (int i = 0; i < mask.length(); ++i) {
            char c = mask.charAt(i);
            if (c == '1' || c == 'T' || c == 't') {
                includedMask[i] = true;
                continue;
            }
            if (c == '0' || c == 'F' || c == 'f') continue;
            throw new IllegalArgumentException("Mask string may contain only '0' and '1'.");
        }
        return this.includeFields(includedMask);
    }

    public CsvReader includeFields(long mask) {
        if (mask == 0L) {
            throw new IllegalArgumentException("The description of fields to parse excluded all fields. At least one fields must be included.");
        }
        ArrayList<Boolean> fields = new ArrayList<Boolean>();
        while (mask != 0L) {
            fields.add((mask & 1L) != 0L);
            mask >>>= 1;
        }
        boolean[] fieldsArray = new boolean[fields.size()];
        for (int i = 0; i < fieldsArray.length; ++i) {
            fieldsArray[i] = (Boolean)fields.get(i);
        }
        return this.includeFields(fieldsArray);
    }

    public CsvReader ignoreFirstLine() {
        this.skipFirstLineAsHeader = true;
        return this;
    }

    public CsvReader ignoreInvalidLines() {
        this.ignoreInvalidLines = true;
        return this;
    }

    public <T> DataSource<T> pojoType(Class<T> pojoType, String ... pojoFields) {
        Preconditions.checkNotNull(pojoType, (String)"The POJO type class must not be null.");
        Preconditions.checkArgument((pojoFields != null && pojoFields.length > 0 ? 1 : 0) != 0, (Object)"POJO fields must be specified (not null) if output type is a POJO.");
        TypeInformation ti = TypeExtractor.createTypeInfo(pojoType);
        if (!(ti instanceof PojoTypeInfo)) {
            throw new IllegalArgumentException("The specified class is not a POJO. The type class must meet the POJO requirements. Found: " + ti);
        }
        PojoTypeInfo pti = (PojoTypeInfo)ti;
        PojoCsvInputFormat inputFormat = new PojoCsvInputFormat(this.path, this.lineDelimiter, this.fieldDelimiter, pti, pojoFields, this.includedMask);
        this.configureInputFormat(inputFormat);
        return new DataSource(this.executionContext, inputFormat, pti, Utils.getCallLocationName());
    }

    public <T extends Tuple> DataSource<T> tupleType(Class<T> targetType) {
        Preconditions.checkNotNull(targetType, (String)"The target type class must not be null.");
        if (!Tuple.class.isAssignableFrom(targetType)) {
            throw new IllegalArgumentException("The target type must be a subclass of " + Tuple.class.getName());
        }
        TupleTypeInfo typeInfo = (TupleTypeInfo)TypeExtractor.createTypeInfo(targetType);
        TupleCsvInputFormat inputFormat = new TupleCsvInputFormat(this.path, this.lineDelimiter, this.fieldDelimiter, typeInfo, this.includedMask);
        Class[] classes = new Class[typeInfo.getArity()];
        for (int i = 0; i < typeInfo.getArity(); ++i) {
            classes[i] = typeInfo.getTypeAt(i).getTypeClass();
        }
        this.configureInputFormat(inputFormat);
        return new DataSource(this.executionContext, inputFormat, typeInfo, Utils.getCallLocationName());
    }

    private void configureInputFormat(CsvInputFormat<?> format) {
        format.setCharset(this.charset);
        format.setDelimiter(this.lineDelimiter);
        format.setFieldDelimiter(this.fieldDelimiter);
        format.setCommentPrefix(this.commentPrefix);
        format.setSkipFirstLineAsHeader(this.skipFirstLineAsHeader);
        format.setLenient(this.ignoreInvalidLines);
        if (this.parseQuotedStrings) {
            format.enableQuotedStringParsing(this.quoteCharacter);
        }
    }

    public <T0> DataSource<Tuple1<T0>> types(Class<T0> type0) {
        TupleTypeInfo types = TupleTypeInfo.getBasicAndBasicValueTupleTypeInfo((Class[])new Class[]{type0});
        TupleCsvInputFormat inputFormat = new TupleCsvInputFormat(this.path, types, this.includedMask);
        this.configureInputFormat(inputFormat);
        return new DataSource<Tuple1<T0>>(this.executionContext, inputFormat, types, Utils.getCallLocationName());
    }

    public <T0, T1> DataSource<Tuple2<T0, T1>> types(Class<T0> type0, Class<T1> type1) {
        TupleTypeInfo types = TupleTypeInfo.getBasicAndBasicValueTupleTypeInfo((Class[])new Class[]{type0, type1});
        TupleCsvInputFormat inputFormat = new TupleCsvInputFormat(this.path, types, this.includedMask);
        this.configureInputFormat(inputFormat);
        return new DataSource<Tuple2<T0, T1>>(this.executionContext, inputFormat, types, Utils.getCallLocationName());
    }

    public <T0, T1, T2> DataSource<Tuple3<T0, T1, T2>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2) {
        TupleTypeInfo types = TupleTypeInfo.getBasicAndBasicValueTupleTypeInfo((Class[])new Class[]{type0, type1, type2});
        TupleCsvInputFormat inputFormat = new TupleCsvInputFormat(this.path, types, this.includedMask);
        this.configureInputFormat(inputFormat);
        return new DataSource<Tuple3<T0, T1, T2>>(this.executionContext, inputFormat, types, Utils.getCallLocationName());
    }

    public <T0, T1, T2, T3> DataSource<Tuple4<T0, T1, T2, T3>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3) {
        TupleTypeInfo types = TupleTypeInfo.getBasicAndBasicValueTupleTypeInfo((Class[])new Class[]{type0, type1, type2, type3});
        TupleCsvInputFormat inputFormat = new TupleCsvInputFormat(this.path, types, this.includedMask);
        this.configureInputFormat(inputFormat);
        return new DataSource<Tuple4<T0, T1, T2, T3>>(this.executionContext, inputFormat, types, Utils.getCallLocationName());
    }

    public <T0, T1, T2, T3, T4> DataSource<Tuple5<T0, T1, T2, T3, T4>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4) {
        TupleTypeInfo types = TupleTypeInfo.getBasicAndBasicValueTupleTypeInfo((Class[])new Class[]{type0, type1, type2, type3, type4});
        TupleCsvInputFormat inputFormat = new TupleCsvInputFormat(this.path, types, this.includedMask);
        this.configureInputFormat(inputFormat);
        return new DataSource<Tuple5<T0, T1, T2, T3, T4>>(this.executionContext, inputFormat, types, Utils.getCallLocationName());
    }

    public <T0, T1, T2, T3, T4, T5> DataSource<Tuple6<T0, T1, T2, T3, T4, T5>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5) {
        TupleTypeInfo types = TupleTypeInfo.getBasicAndBasicValueTupleTypeInfo((Class[])new Class[]{type0, type1, type2, type3, type4, type5});
        TupleCsvInputFormat inputFormat = new TupleCsvInputFormat(this.path, types, this.includedMask);
        this.configureInputFormat(inputFormat);
        return new DataSource<Tuple6<T0, T1, T2, T3, T4, T5>>(this.executionContext, inputFormat, types, Utils.getCallLocationName());
    }

    public <T0, T1, T2, T3, T4, T5, T6> DataSource<Tuple7<T0, T1, T2, T3, T4, T5, T6>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6) {
        TupleTypeInfo types = TupleTypeInfo.getBasicAndBasicValueTupleTypeInfo((Class[])new Class[]{type0, type1, type2, type3, type4, type5, type6});
        TupleCsvInputFormat inputFormat = new TupleCsvInputFormat(this.path, types, this.includedMask);
        this.configureInputFormat(inputFormat);
        return new DataSource<Tuple7<T0, T1, T2, T3, T4, T5, T6>>(this.executionContext, inputFormat, types, Utils.getCallLocationName());
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7> DataSource<Tuple8<T0, T1, T2, T3, T4, T5, T6, T7>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7) {
        TupleTypeInfo types = TupleTypeInfo.getBasicAndBasicValueTupleTypeInfo((Class[])new Class[]{type0, type1, type2, type3, type4, type5, type6, type7});
        TupleCsvInputFormat inputFormat = new TupleCsvInputFormat(this.path, types, this.includedMask);
        this.configureInputFormat(inputFormat);
        return new DataSource<Tuple8<T0, T1, T2, T3, T4, T5, T6, T7>>(this.executionContext, inputFormat, types, Utils.getCallLocationName());
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8> DataSource<Tuple9<T0, T1, T2, T3, T4, T5, T6, T7, T8>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8) {
        TupleTypeInfo types = TupleTypeInfo.getBasicAndBasicValueTupleTypeInfo((Class[])new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8});
        TupleCsvInputFormat inputFormat = new TupleCsvInputFormat(this.path, types, this.includedMask);
        this.configureInputFormat(inputFormat);
        return new DataSource<Tuple9<T0, T1, T2, T3, T4, T5, T6, T7, T8>>(this.executionContext, inputFormat, types, Utils.getCallLocationName());
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9> DataSource<Tuple10<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9) {
        TupleTypeInfo types = TupleTypeInfo.getBasicAndBasicValueTupleTypeInfo((Class[])new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9});
        TupleCsvInputFormat inputFormat = new TupleCsvInputFormat(this.path, types, this.includedMask);
        this.configureInputFormat(inputFormat);
        return new DataSource<Tuple10<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9>>(this.executionContext, inputFormat, types, Utils.getCallLocationName());
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> DataSource<Tuple11<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10) {
        TupleTypeInfo types = TupleTypeInfo.getBasicAndBasicValueTupleTypeInfo((Class[])new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10});
        TupleCsvInputFormat inputFormat = new TupleCsvInputFormat(this.path, types, this.includedMask);
        this.configureInputFormat(inputFormat);
        return new DataSource<Tuple11<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>>(this.executionContext, inputFormat, types, Utils.getCallLocationName());
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> DataSource<Tuple12<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11) {
        TupleTypeInfo types = TupleTypeInfo.getBasicAndBasicValueTupleTypeInfo((Class[])new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11});
        TupleCsvInputFormat inputFormat = new TupleCsvInputFormat(this.path, types, this.includedMask);
        this.configureInputFormat(inputFormat);
        return new DataSource<Tuple12<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>>(this.executionContext, inputFormat, types, Utils.getCallLocationName());
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> DataSource<Tuple13<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12) {
        TupleTypeInfo types = TupleTypeInfo.getBasicAndBasicValueTupleTypeInfo((Class[])new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12});
        TupleCsvInputFormat inputFormat = new TupleCsvInputFormat(this.path, types, this.includedMask);
        this.configureInputFormat(inputFormat);
        return new DataSource<Tuple13<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>>(this.executionContext, inputFormat, types, Utils.getCallLocationName());
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> DataSource<Tuple14<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13) {
        TupleTypeInfo types = TupleTypeInfo.getBasicAndBasicValueTupleTypeInfo((Class[])new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13});
        TupleCsvInputFormat inputFormat = new TupleCsvInputFormat(this.path, types, this.includedMask);
        this.configureInputFormat(inputFormat);
        return new DataSource<Tuple14<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>>(this.executionContext, inputFormat, types, Utils.getCallLocationName());
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> DataSource<Tuple15<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13, Class<T14> type14) {
        TupleTypeInfo types = TupleTypeInfo.getBasicAndBasicValueTupleTypeInfo((Class[])new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13, type14});
        TupleCsvInputFormat inputFormat = new TupleCsvInputFormat(this.path, types, this.includedMask);
        this.configureInputFormat(inputFormat);
        return new DataSource<Tuple15<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>>(this.executionContext, inputFormat, types, Utils.getCallLocationName());
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> DataSource<Tuple16<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13, Class<T14> type14, Class<T15> type15) {
        TupleTypeInfo types = TupleTypeInfo.getBasicAndBasicValueTupleTypeInfo((Class[])new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13, type14, type15});
        TupleCsvInputFormat inputFormat = new TupleCsvInputFormat(this.path, types, this.includedMask);
        this.configureInputFormat(inputFormat);
        return new DataSource<Tuple16<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>>(this.executionContext, inputFormat, types, Utils.getCallLocationName());
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> DataSource<Tuple17<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13, Class<T14> type14, Class<T15> type15, Class<T16> type16) {
        TupleTypeInfo types = TupleTypeInfo.getBasicAndBasicValueTupleTypeInfo((Class[])new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13, type14, type15, type16});
        TupleCsvInputFormat inputFormat = new TupleCsvInputFormat(this.path, types, this.includedMask);
        this.configureInputFormat(inputFormat);
        return new DataSource<Tuple17<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>>(this.executionContext, inputFormat, types, Utils.getCallLocationName());
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17> DataSource<Tuple18<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13, Class<T14> type14, Class<T15> type15, Class<T16> type16, Class<T17> type17) {
        TupleTypeInfo types = TupleTypeInfo.getBasicAndBasicValueTupleTypeInfo((Class[])new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13, type14, type15, type16, type17});
        TupleCsvInputFormat inputFormat = new TupleCsvInputFormat(this.path, types, this.includedMask);
        this.configureInputFormat(inputFormat);
        return new DataSource<Tuple18<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17>>(this.executionContext, inputFormat, types, Utils.getCallLocationName());
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18> DataSource<Tuple19<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13, Class<T14> type14, Class<T15> type15, Class<T16> type16, Class<T17> type17, Class<T18> type18) {
        TupleTypeInfo types = TupleTypeInfo.getBasicAndBasicValueTupleTypeInfo((Class[])new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13, type14, type15, type16, type17, type18});
        TupleCsvInputFormat inputFormat = new TupleCsvInputFormat(this.path, types, this.includedMask);
        this.configureInputFormat(inputFormat);
        return new DataSource<Tuple19<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18>>(this.executionContext, inputFormat, types, Utils.getCallLocationName());
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19> DataSource<Tuple20<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13, Class<T14> type14, Class<T15> type15, Class<T16> type16, Class<T17> type17, Class<T18> type18, Class<T19> type19) {
        TupleTypeInfo types = TupleTypeInfo.getBasicAndBasicValueTupleTypeInfo((Class[])new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13, type14, type15, type16, type17, type18, type19});
        TupleCsvInputFormat inputFormat = new TupleCsvInputFormat(this.path, types, this.includedMask);
        this.configureInputFormat(inputFormat);
        return new DataSource<Tuple20<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19>>(this.executionContext, inputFormat, types, Utils.getCallLocationName());
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20> DataSource<Tuple21<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13, Class<T14> type14, Class<T15> type15, Class<T16> type16, Class<T17> type17, Class<T18> type18, Class<T19> type19, Class<T20> type20) {
        TupleTypeInfo types = TupleTypeInfo.getBasicAndBasicValueTupleTypeInfo((Class[])new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13, type14, type15, type16, type17, type18, type19, type20});
        TupleCsvInputFormat inputFormat = new TupleCsvInputFormat(this.path, types, this.includedMask);
        this.configureInputFormat(inputFormat);
        return new DataSource<Tuple21<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20>>(this.executionContext, inputFormat, types, Utils.getCallLocationName());
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21> DataSource<Tuple22<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13, Class<T14> type14, Class<T15> type15, Class<T16> type16, Class<T17> type17, Class<T18> type18, Class<T19> type19, Class<T20> type20, Class<T21> type21) {
        TupleTypeInfo types = TupleTypeInfo.getBasicAndBasicValueTupleTypeInfo((Class[])new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13, type14, type15, type16, type17, type18, type19, type20, type21});
        TupleCsvInputFormat inputFormat = new TupleCsvInputFormat(this.path, types, this.includedMask);
        this.configureInputFormat(inputFormat);
        return new DataSource<Tuple22<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21>>(this.executionContext, inputFormat, types, Utils.getCallLocationName());
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22> DataSource<Tuple23<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13, Class<T14> type14, Class<T15> type15, Class<T16> type16, Class<T17> type17, Class<T18> type18, Class<T19> type19, Class<T20> type20, Class<T21> type21, Class<T22> type22) {
        TupleTypeInfo types = TupleTypeInfo.getBasicAndBasicValueTupleTypeInfo((Class[])new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13, type14, type15, type16, type17, type18, type19, type20, type21, type22});
        TupleCsvInputFormat inputFormat = new TupleCsvInputFormat(this.path, types, this.includedMask);
        this.configureInputFormat(inputFormat);
        return new DataSource<Tuple23<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22>>(this.executionContext, inputFormat, types, Utils.getCallLocationName());
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23> DataSource<Tuple24<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13, Class<T14> type14, Class<T15> type15, Class<T16> type16, Class<T17> type17, Class<T18> type18, Class<T19> type19, Class<T20> type20, Class<T21> type21, Class<T22> type22, Class<T23> type23) {
        TupleTypeInfo types = TupleTypeInfo.getBasicAndBasicValueTupleTypeInfo((Class[])new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13, type14, type15, type16, type17, type18, type19, type20, type21, type22, type23});
        TupleCsvInputFormat inputFormat = new TupleCsvInputFormat(this.path, types, this.includedMask);
        this.configureInputFormat(inputFormat);
        return new DataSource<Tuple24<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23>>(this.executionContext, inputFormat, types, Utils.getCallLocationName());
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24> DataSource<Tuple25<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13, Class<T14> type14, Class<T15> type15, Class<T16> type16, Class<T17> type17, Class<T18> type18, Class<T19> type19, Class<T20> type20, Class<T21> type21, Class<T22> type22, Class<T23> type23, Class<T24> type24) {
        TupleTypeInfo types = TupleTypeInfo.getBasicAndBasicValueTupleTypeInfo((Class[])new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13, type14, type15, type16, type17, type18, type19, type20, type21, type22, type23, type24});
        TupleCsvInputFormat inputFormat = new TupleCsvInputFormat(this.path, types, this.includedMask);
        this.configureInputFormat(inputFormat);
        return new DataSource<Tuple25<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24>>(this.executionContext, inputFormat, types, Utils.getCallLocationName());
    }
}

