/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.utils;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class MixedDataFiles {
    public static final LocalDateTime EPOCH = LocalDateTime.ofEpochSecond(0L, 0, ZoneOffset.UTC);
    private static final DateTimeFormatter FORMAT_HOUR = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH");
    private static final int EPOCH_YEAR = EPOCH.getYear();
    private static final String HIVE_NULL = "__HIVE_DEFAULT_PARTITION__";
    private static final String MONTH_TYPE = "month";
    private static final String HOUR_TYPE = "hour";

    public static Integer readMonthData(String dateStr) {
        String[] dateParts = dateStr.split("-", -1);
        int year = Integer.parseInt(dateParts[0]);
        int month = Integer.parseInt(dateParts[1]);
        return Math.multiplyExact(year - EPOCH_YEAR, 12) + month - 1;
    }

    private static Integer readHoursData(String asString) {
        LocalDateTime dateTime = LocalDateTime.parse(asString, FORMAT_HOUR);
        return Math.toIntExact(ChronoUnit.HOURS.between(EPOCH, dateTime));
    }

    public static Object fromPartitionString(PartitionField field, Type type, String asString) {
        if (asString == null || HIVE_NULL.equals(asString)) {
            return null;
        }
        switch (type.typeId()) {
            case BOOLEAN: {
                return Boolean.valueOf(asString);
            }
            case INTEGER: {
                if (MONTH_TYPE.equals(field.transform().toString())) {
                    return MixedDataFiles.readMonthData(asString);
                }
                if (HOUR_TYPE.equals(field.transform().toString())) {
                    return MixedDataFiles.readHoursData(asString);
                }
                return Integer.valueOf(asString);
            }
            case STRING: {
                return asString;
            }
            case LONG: {
                return Long.valueOf(asString);
            }
            case FLOAT: {
                return Float.valueOf(asString);
            }
            case DOUBLE: {
                return Double.valueOf(asString);
            }
            case UUID: {
                return UUID.fromString(asString);
            }
            case FIXED: {
                Types.FixedType fixed = (Types.FixedType)type;
                return Arrays.copyOf(asString.getBytes(StandardCharsets.UTF_8), fixed.length());
            }
            case BINARY: {
                return asString.getBytes(StandardCharsets.UTF_8);
            }
            case DECIMAL: {
                return new BigDecimal(asString);
            }
            case DATE: {
                return Literal.of((CharSequence)asString).to((Type)Types.DateType.get()).value();
            }
        }
        throw new UnsupportedOperationException("Unsupported type for fromPartitionString: " + type);
    }

    public static GenericRecord data(PartitionSpec spec, String partitionPath) {
        GenericRecord data = MixedDataFiles.genericRecord(spec);
        String[] partitions = partitionPath.split("/", -1);
        Preconditions.checkArgument((partitions.length <= spec.fields().size() ? 1 : 0) != 0, (String)"Invalid partition data, too many fields (expecting %s): %s", (int)spec.fields().size(), (Object)partitionPath);
        Preconditions.checkArgument((partitions.length >= spec.fields().size() ? 1 : 0) != 0, (String)"Invalid partition data, not enough fields (expecting %s): %s", (int)spec.fields().size(), (Object)partitionPath);
        for (int i = 0; i < partitions.length; ++i) {
            String value;
            PartitionField field = (PartitionField)spec.fields().get(i);
            String[] parts = partitions[i].split("=", 2);
            Preconditions.checkArgument((parts.length == 2 && parts[0] != null && field.name().equals(parts[0]) ? 1 : 0) != 0, (String)"Invalid partition: %s", (Object)partitions[i]);
            if ("null".equals(parts[1])) {
                value = null;
            } else {
                try {
                    value = URLDecoder.decode(parts[1], "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException(String.format("failed to decode %s of %s", parts[1], partitionPath), e);
                }
            }
            data.set(i, MixedDataFiles.fromPartitionString(field, spec.partitionType().fieldType(parts[0]), value));
        }
        return data;
    }

    private static GenericRecord genericRecord(PartitionSpec spec) {
        List collect = spec.fields().stream().map(s -> spec.schema().findColumnName(s.sourceId())).collect(Collectors.toList());
        return GenericRecord.create((Schema)spec.schema().select(collect));
    }
}

