/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.ClosableConcurrentStack;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.DelayedCancellable;
import java.util.function.Consumer;
import javax.annotation.Nullable;

final class SingleProcessor<T>
extends Single<T>
implements SingleSource.Processor<T, T> {
    private final ClosableConcurrentStack<SingleSource.Subscriber<? super T>> stack = new ClosableConcurrentStack();

    SingleProcessor() {
    }

    @Override
    protected void handleSubscribe(SingleSource.Subscriber<? super T> subscriber) {
        DelayedCancellable delayedCancellable = new DelayedCancellable();
        subscriber.onSubscribe((Cancellable)delayedCancellable);
        if (this.stack.push(subscriber)) {
            delayedCancellable.delayedCancellable(() -> this.stack.relaxedRemove(subscriber));
        }
    }

    public void onSubscribe(Cancellable cancellable) {
    }

    public void onSuccess(@Nullable T result) {
        this.terminate(s -> s.onSuccess(result));
    }

    public void onError(Throwable t) {
        this.terminate(s -> s.onError(t));
    }

    private void terminate(Consumer<SingleSource.Subscriber<? super T>> terminalSignal) {
        this.stack.close(terminalSignal);
    }

    public void subscribe(SingleSource.Subscriber<? super T> subscriber) {
        this.subscribeInternal(subscriber);
    }
}

