/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.channel.ChannelHandlerContext;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.netty.HttpObjectDecoder;
import io.servicetalk.http.netty.HttpObjectEncoder;
import io.servicetalk.transport.netty.internal.CloseHandler;
import java.util.Objects;
import java.util.Queue;

final class HttpResponseEncoder
extends HttpObjectEncoder<HttpResponseMetaData> {
    static final OnResponse NOOP_ON_RESPONSE = (ctx, status) -> {};
    private final Queue<HttpRequestMethod> methodQueue;
    private final OnResponse onResponse;

    HttpResponseEncoder(Queue<HttpRequestMethod> methodQueue, int headersEncodedSizeAccumulator, int trailersEncodedSizeAccumulator, CloseHandler closeHandler, OnResponse onResponse) {
        super(headersEncodedSizeAccumulator, trailersEncodedSizeAccumulator, closeHandler);
        this.methodQueue = Objects.requireNonNull(methodQueue);
        this.onResponse = Objects.requireNonNull(onResponse);
    }

    @Override
    protected HttpResponseMetaData castMetaData(Object msg) {
        return (HttpResponseMetaData)msg;
    }

    @Override
    protected void encodeInitialLine(ChannelHandlerContext ctx, Buffer stBuffer, HttpResponseMetaData message) {
        message.version().writeTo(stBuffer);
        stBuffer.writeByte(32);
        message.status().writeTo(stBuffer);
        stBuffer.writeShort(3338);
        this.onResponse.onResponse(ctx, message.status());
    }

    @Override
    protected long getContentLength(HttpResponseMetaData message) {
        return HttpObjectDecoder.getContentLength((HttpMetaData)message);
    }

    @Override
    protected void sanitizeHeadersBeforeEncode(HttpResponseMetaData msg, boolean isAlwaysEmpty) {
        HttpRequestMethod method = this.methodQueue.poll();
        HttpHeaders headers = msg.headers();
        if (isAlwaysEmpty) {
            HttpResponseStatus status = msg.status();
            if (status.statusClass() == HttpResponseStatus.StatusClass.INFORMATIONAL_1XX || status.code() == HttpResponseStatus.NO_CONTENT.code()) {
                headers.remove(HttpHeaderNames.CONTENT_LENGTH);
                headers.remove(HttpHeaderNames.TRANSFER_ENCODING);
            }
        } else if (HttpRequestMethod.CONNECT.equals((Object)method) && msg.status().statusClass() == HttpResponseStatus.StatusClass.SUCCESSFUL_2XX) {
            headers.remove(HttpHeaderNames.CONTENT_LENGTH);
            headers.remove(HttpHeaderNames.TRANSFER_ENCODING);
        }
    }

    @Override
    protected boolean isContentAlwaysEmpty(HttpResponseMetaData msg) {
        HttpRequestMethod method = this.methodQueue.peek();
        if (HttpRequestMethod.HEAD.equals((Object)method)) {
            return true;
        }
        HttpResponseStatus status = msg.status();
        if (status.statusClass() == HttpResponseStatus.StatusClass.INFORMATIONAL_1XX) {
            if (status.code() == HttpResponseStatus.SWITCHING_PROTOCOLS.code()) {
                return msg.headers().contains(HttpHeaderNames.SEC_WEBSOCKET_VERSION);
            }
            return true;
        }
        return status.code() == HttpResponseStatus.NO_CONTENT.code() || status.code() == HttpResponseStatus.NOT_MODIFIED.code();
    }

    @Override
    protected boolean isInterim(HttpResponseMetaData msg) {
        return msg.status().statusClass() == HttpResponseStatus.StatusClass.INFORMATIONAL_1XX;
    }

    static interface OnResponse {
        public void onResponse(ChannelHandlerContext var1, HttpResponseStatus var2);
    }
}

