/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.collection.type;

import java.nio.ByteBuffer;
import org.apache.baremaps.collection.type.DataType;
import org.apache.baremaps.openstreetmap.utils.GeometryUtils;
import org.locationtech.jts.geom.Geometry;

public class GeometryDataType
implements DataType<Geometry> {
    @Override
    public int size(Geometry value) {
        return 4 + GeometryUtils.serialize(value).length;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return buffer.getInt(position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, Geometry value) {
        byte[] bytes = GeometryUtils.serialize(value);
        buffer.putInt(position, 4 + bytes.length);
        buffer.put(position + 4, bytes);
    }

    @Override
    public Geometry read(ByteBuffer buffer, int position) {
        int size = buffer.getInt(position);
        byte[] bytes = new byte[Math.max(size - 4, 0)];
        buffer.get(position + 4, bytes);
        return GeometryUtils.deserialize(bytes);
    }
}

