/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.utils;

import org.apache.baremaps.openstreetmap.utils.ProjectionTransformer;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.proj4j.CRSFactory;
import org.locationtech.proj4j.CoordinateReferenceSystem;
import org.locationtech.proj4j.CoordinateTransform;
import org.locationtech.proj4j.CoordinateTransformFactory;

public class GeometryUtils {
    public static final GeometryFactory GEOMETRY_FACTORY_WGS84 = new GeometryFactory(new PrecisionModel(), 4326);

    private GeometryUtils() {
    }

    public static byte[] serialize(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        WKBWriter writer = new WKBWriter(2, 1, true);
        return writer.write(geometry);
    }

    public static Geometry deserialize(byte[] wkb) {
        if (wkb == null) {
            return null;
        }
        try {
            WKBReader reader = new WKBReader(new GeometryFactory());
            return reader.read(wkb);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static CoordinateTransform coordinateTransform(Integer sourceSRID, Integer targetSRID) {
        CRSFactory crsFactory = new CRSFactory();
        CoordinateReferenceSystem sourceCRS = crsFactory.createFromName(String.format("EPSG:%d", sourceSRID));
        CoordinateReferenceSystem targetCRS = crsFactory.createFromName(String.format("EPSG:%d", targetSRID));
        CoordinateTransformFactory coordinateTransformFactory = new CoordinateTransformFactory();
        return coordinateTransformFactory.createTransform(sourceCRS, targetCRS);
    }

    public static ProjectionTransformer projectionTransformer(int inputSRID, int outputSRID) {
        return new ProjectionTransformer(inputSRID, outputSRID);
    }
}

