/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.baremaps.geocoder.GeonamesQueryBuilder;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TopDocs;

@Singleton
@Path(value="/")
public class GeocoderResources {
    private final SearcherManager searcherManager;

    @Inject
    public GeocoderResources(SearcherManager searcherManager) {
        this.searcherManager = searcherManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/api/geocoder")
    public Response getIpToLocation(@QueryParam(value="queryText") String queryText, @QueryParam(value="countryCode") @DefaultValue(value="") String countryCode, @QueryParam(value="limit") @DefaultValue(value="10") int limit) throws IOException {
        if (queryText == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"The queryText parameter is mandatory").build());
        }
        Query query = new GeonamesQueryBuilder().queryText(queryText).countryCode(countryCode).build();
        IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
        try {
            TopDocs result = searcher.search(query, limit);
            List<GeocoderResult> results = Arrays.stream(result.scoreDocs).map(scoreDoc -> this.asResult(searcher, (ScoreDoc)scoreDoc)).toList();
            Response response = Response.status((int)200).header("Access-Control-Allow-Origin", (Object)"*").header("Content-Type", (Object)"application/json").entity((Object)new GeocoderResponse(results)).build();
            return response;
        }
        catch (IllegalArgumentException e) {
            Response response = Response.status((int)400).entity((Object)e.getMessage()).build();
            return response;
        }
        catch (IOException e) {
            Response response = Response.status((int)500).entity((Object)e.getMessage()).build();
            return response;
        }
        finally {
            this.searcherManager.release((Object)searcher);
        }
    }

    private GeocoderResult asResult(IndexSearcher indexSearcher, ScoreDoc scoreDoc) {
        try {
            Document document = indexSearcher.doc(scoreDoc.doc);
            HashMap<String, Object> data = new HashMap<String, Object>();
            for (IndexableField field : document.getFields()) {
                if (field.numericValue() != null) {
                    data.put(field.name(), field.numericValue());
                    continue;
                }
                if (field.stringValue() == null) continue;
                data.put(field.name(), field.stringValue());
            }
            return new GeocoderResult(scoreDoc.score, data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @GET
    @Path(value="/{path:.*}")
    public Response get(@PathParam(value="path") String path) {
        Response response;
        block9: {
            if (((String)path).equals("") || ((String)path).endsWith("/")) {
                path = (String)path + "index.html";
            }
            path = String.format("geocoder/%s", path);
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream((String)path);
            try {
                byte[] bytes = inputStream.readAllBytes();
                response = Response.ok().entity((Object)bytes).build();
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return Response.status((int)404).build();
                }
            }
            inputStream.close();
        }
        return response;
    }

    record GeocoderResponse(List<GeocoderResult> results) {
    }

    record GeocoderResult(float score, Map<String, Object> data) {
    }
}

