/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.baremaps.database.tile.Tile;
import org.apache.baremaps.database.tile.TileStore;
import org.apache.baremaps.database.tile.TileStoreException;
import org.apache.baremaps.mvt.style.Style;
import org.apache.baremaps.mvt.tileset.Tileset;
import org.apache.baremaps.mvt.tileset.TilesetLayer;
import org.apache.baremaps.server.ConfigReader;

@Singleton
@Path(value="/")
public class ServerResources {
    private final Style style;
    private final Tileset tileset;
    private final TileStore tileStore;
    public static final String TILE_ENCODING = "gzip";
    public static final String TILE_TYPE = "application/vnd.mapbox-vector-tile";

    @Inject
    public ServerResources(@Named(value="tileset") java.nio.file.Path tileset, @Named(value="style") java.nio.file.Path style, TileStore tileStore, ObjectMapper objectMapper) throws IOException {
        this.tileStore = tileStore;
        ConfigReader configReader = new ConfigReader();
        this.style = (Style)objectMapper.readValue(configReader.read(style), Style.class);
        this.tileset = (Tileset)objectMapper.readValue(configReader.read(tileset), Tileset.class);
        for (TilesetLayer layer : this.tileset.getVectorLayers()) {
            layer.setQueries(null);
        }
    }

    @GET
    @Path(value="style.json")
    @Produces(value={"application/json"})
    public Style getStyle() {
        return this.style;
    }

    @GET
    @Path(value="tiles.json")
    @Produces(value={"application/json"})
    public Tileset getTileset() {
        return this.tileset;
    }

    @GET
    @Path(value="/tiles/{z}/{x}/{y}.mvt")
    public Response getTile(@PathParam(value="z") int z, @PathParam(value="x") int x, @PathParam(value="y") int y) {
        Tile tile = new Tile(x, y, z);
        try {
            ByteBuffer blob = this.tileStore.read(tile);
            if (blob != null) {
                return Response.status((int)200).header("Access-Control-Allow-Origin", (Object)"*").header("Content-Type", (Object)TILE_TYPE).header("Content-Encoding", (Object)TILE_ENCODING).entity((Object)blob.array()).build();
            }
            return Response.status((int)204).build();
        }
        catch (TileStoreException ex) {
            return Response.status((int)404).build();
        }
    }

    @GET
    @Path(value="{path:.*}")
    public Response get(@PathParam(value="path") String path) throws IOException {
        Response response;
        block9: {
            if (((String)path).equals("") || ((String)path).endsWith("/")) {
                path = (String)path + "server.html";
            }
            path = String.format("assets/%s", path);
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream((String)path);
            try {
                byte[] bytes = inputStream.readAllBytes();
                response = Response.ok().entity((Object)bytes).build();
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return Response.status((int)404).build();
                }
            }
            inputStream.close();
        }
        return response;
    }
}

