/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.internal.BlockingUtils;
import io.servicetalk.http.api.BlockingHttpService;
import io.servicetalk.http.api.BlockingStreamingHttpService;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpLifecycleObserver;
import io.servicetalk.http.api.HttpProtocolConfig;
import io.servicetalk.http.api.HttpServerContext;
import io.servicetalk.http.api.HttpService;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceFilterFactory;
import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.transport.api.ConnectionAcceptorFactory;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.transport.api.ServerSslConfig;
import io.servicetalk.transport.api.TransportObserver;
import java.net.SocketOption;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;

public interface HttpServerBuilder {
    public HttpServerBuilder protocols(HttpProtocolConfig ... var1);

    public HttpServerBuilder sslConfig(ServerSslConfig var1);

    public HttpServerBuilder sslConfig(ServerSslConfig var1, Map<String, ServerSslConfig> var2);

    public <T> HttpServerBuilder socketOption(SocketOption<T> var1, T var2);

    public <T> HttpServerBuilder listenSocketOption(SocketOption<T> var1, T var2);

    public HttpServerBuilder enableWireLogging(String var1, LogLevel var2, BooleanSupplier var3);

    public HttpServerBuilder transportObserver(TransportObserver var1);

    public HttpServerBuilder lifecycleObserver(HttpLifecycleObserver var1);

    public HttpServerBuilder drainRequestPayloadBody(boolean var1);

    public HttpServerBuilder allowDropRequestTrailers(boolean var1);

    public HttpServerBuilder appendConnectionAcceptorFilter(ConnectionAcceptorFactory var1);

    public HttpServerBuilder appendNonOffloadingServiceFilter(StreamingHttpServiceFilterFactory var1);

    public HttpServerBuilder appendNonOffloadingServiceFilter(Predicate<StreamingHttpRequest> var1, StreamingHttpServiceFilterFactory var2);

    public HttpServerBuilder appendServiceFilter(StreamingHttpServiceFilterFactory var1);

    public HttpServerBuilder appendServiceFilter(Predicate<StreamingHttpRequest> var1, StreamingHttpServiceFilterFactory var2);

    public HttpServerBuilder ioExecutor(IoExecutor var1);

    public HttpServerBuilder executor(Executor var1);

    public HttpServerBuilder bufferAllocator(BufferAllocator var1);

    public HttpServerBuilder executionStrategy(HttpExecutionStrategy var1);

    default public HttpServerContext listenAndAwait(HttpService service) throws Exception {
        return (HttpServerContext)BlockingUtils.blockingInvocation(this.listen(service));
    }

    default public HttpServerContext listenStreamingAndAwait(StreamingHttpService service) throws Exception {
        return (HttpServerContext)BlockingUtils.blockingInvocation(this.listenStreaming(service));
    }

    default public HttpServerContext listenBlockingAndAwait(BlockingHttpService service) throws Exception {
        return (HttpServerContext)BlockingUtils.blockingInvocation(this.listenBlocking(service));
    }

    default public HttpServerContext listenBlockingStreamingAndAwait(BlockingStreamingHttpService service) throws Exception {
        return (HttpServerContext)BlockingUtils.blockingInvocation(this.listenBlockingStreaming(service));
    }

    public Single<HttpServerContext> listen(HttpService var1);

    public Single<HttpServerContext> listenStreaming(StreamingHttpService var1);

    public Single<HttpServerContext> listenBlocking(BlockingHttpService var1);

    public Single<HttpServerContext> listenBlockingStreaming(BlockingStreamingHttpService var1);
}

