/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;

@ApiModel(description="Variable Matrix Width data structure")
@JsonTypeName(value="variableMatrixWidth")
public class VariableMatrixWidth {
    @Valid
    private BigDecimal coalesce;
    @Valid
    private BigDecimal minTileRow;
    @Valid
    private BigDecimal maxTileRow;

    public VariableMatrixWidth coalesce(BigDecimal coalesce) {
        this.coalesce = coalesce;
        return this;
    }

    @ApiModelProperty(required=true, value="Number of tiles in width that coalesce in a single tile for these rows")
    @JsonProperty(value="coalesce")
    @NotNull
    @DecimalMin(value="2")
    public @NotNull @DecimalMin(value="2") BigDecimal getCoalesce() {
        return this.coalesce;
    }

    @JsonProperty(value="coalesce")
    public void setCoalesce(BigDecimal coalesce) {
        this.coalesce = coalesce;
    }

    public VariableMatrixWidth minTileRow(BigDecimal minTileRow) {
        this.minTileRow = minTileRow;
        return this;
    }

    @ApiModelProperty(required=true, value="First tile row where the coalescence factor applies for this tilematrix")
    @JsonProperty(value="minTileRow")
    @NotNull
    @DecimalMin(value="0")
    public @NotNull @DecimalMin(value="0") BigDecimal getMinTileRow() {
        return this.minTileRow;
    }

    @JsonProperty(value="minTileRow")
    public void setMinTileRow(BigDecimal minTileRow) {
        this.minTileRow = minTileRow;
    }

    public VariableMatrixWidth maxTileRow(BigDecimal maxTileRow) {
        this.maxTileRow = maxTileRow;
        return this;
    }

    @ApiModelProperty(required=true, value="Last tile row where the coalescence factor applies for this tilematrix")
    @JsonProperty(value="maxTileRow")
    @NotNull
    @DecimalMin(value="0")
    public @NotNull @DecimalMin(value="0") BigDecimal getMaxTileRow() {
        return this.maxTileRow;
    }

    @JsonProperty(value="maxTileRow")
    public void setMaxTileRow(BigDecimal maxTileRow) {
        this.maxTileRow = maxTileRow;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariableMatrixWidth variableMatrixWidth = (VariableMatrixWidth)o;
        return Objects.equals(this.coalesce, variableMatrixWidth.coalesce) && Objects.equals(this.minTileRow, variableMatrixWidth.minTileRow) && Objects.equals(this.maxTileRow, variableMatrixWidth.maxTileRow);
    }

    public int hashCode() {
        return Objects.hash(this.coalesce, this.minTileRow, this.maxTileRow);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VariableMatrixWidth {\n");
        sb.append("    coalesce: ").append(this.toIndentedString(this.coalesce)).append("\n");
        sb.append("    minTileRow: ").append(this.toIndentedString(this.minTileRow)).append("\n");
        sb.append("    maxTileRow: ").append(this.toIndentedString(this.maxTileRow)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

