/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.channel.Channel;
import io.servicetalk.concurrent.api.AsyncCloseable;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.CompositeCloseable;
import io.servicetalk.concurrent.api.Executors;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import io.servicetalk.transport.api.ExecutionContext;
import io.servicetalk.transport.api.ServerContext;
import io.servicetalk.transport.netty.internal.NettyChannelListenableAsyncCloseable;
import java.net.SocketAddress;
import javax.annotation.Nullable;

public final class NettyServerContext
implements ServerContext {
    private final Channel listenChannel;
    private final ListenableAsyncCloseable closeable;
    private final ExecutionContext<?> executionContext;

    private NettyServerContext(Channel listenChannel, ListenableAsyncCloseable closeable, ExecutionContext<?> executionContext) {
        this.listenChannel = listenChannel;
        this.closeable = closeable;
        this.executionContext = executionContext;
    }

    public static ServerContext wrap(NettyServerContext toWrap, AsyncCloseable closeBefore) {
        return new NettyServerContext(toWrap.listenChannel, AsyncCloseables.toListenableAsyncCloseable((AsyncCloseable)AsyncCloseables.newCompositeCloseable().appendAll(new AsyncCloseable[]{closeBefore, toWrap.closeable})), toWrap.executionContext);
    }

    public static ServerContext wrap(Channel listenChannel, ListenableAsyncCloseable channelSetCloseable, @Nullable AsyncCloseable closeBefore, ExecutionContext<?> executionContext) {
        NettyChannelListenableAsyncCloseable channelCloseable = new NettyChannelListenableAsyncCloseable(listenChannel, executionContext.executionStrategy().isCloseOffloaded() ? executionContext.executor() : Executors.immediate());
        CompositeCloseable closeAsync = closeBefore == null ? AsyncCloseables.newCompositeCloseable().appendAll(new AsyncCloseable[]{channelCloseable, channelSetCloseable}) : AsyncCloseables.newCompositeCloseable().appendAll(new AsyncCloseable[]{closeBefore, channelCloseable, channelSetCloseable});
        return new NettyServerContext(listenChannel, AsyncCloseables.toListenableAsyncCloseable((AsyncCloseable)closeAsync), executionContext);
    }

    public SocketAddress listenAddress() {
        return this.listenChannel.localAddress();
    }

    public void acceptConnections(boolean accept) {
        this.listenChannel.config().setAutoRead(accept);
    }

    public ExecutionContext<?> executionContext() {
        return this.executionContext;
    }

    public Completable closeAsync() {
        return this.closeable.closeAsync();
    }

    public Completable closeAsyncGracefully() {
        return this.closeable.closeAsyncGracefully();
    }

    public Completable onClose() {
        return this.closeable.onClose();
    }

    public Completable onClosing() {
        return this.closeable.onClosing();
    }
}

