/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.schema;

import java.util.List;
import java.util.function.Function;
import org.apache.baremaps.database.schema.DataColumn;
import org.apache.baremaps.database.schema.DataRow;
import org.apache.baremaps.database.schema.DataTable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.util.GeometryTransformer;

public class DataTableGeometryTransformer
implements Function<DataRow, DataRow> {
    private final DataTable table;
    private final GeometryTransformer geometryTransformer;

    public DataTableGeometryTransformer(DataTable table, GeometryTransformer geometryTransformer) {
        this.table = table;
        this.geometryTransformer = geometryTransformer;
    }

    @Override
    public DataRow apply(DataRow row) {
        List<DataColumn> columns = this.table.rowType().columns().stream().filter(column -> column.type().binding().isAssignableFrom(Geometry.class)).toList();
        for (DataColumn column2 : columns) {
            String name = column2.name();
            Geometry geometry = (Geometry)row.get(name);
            if (geometry == null) continue;
            row.set(name, (Object)this.geometryTransformer.transform(geometry));
        }
        return row;
    }
}

