/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.function;

import java.util.List;
import java.util.function.Consumer;
import org.apache.baremaps.database.collection.DataMap;
import org.apache.baremaps.openstreetmap.model.Way;
import org.apache.baremaps.utils.GeometryUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WayGeometryBuilder
implements Consumer<Way> {
    private static final Logger logger = LoggerFactory.getLogger(WayGeometryBuilder.class);
    private final DataMap<Long, Coordinate> coordinateMap;

    public WayGeometryBuilder(DataMap<Long, Coordinate> coordinateMap) {
        this.coordinateMap = coordinateMap;
    }

    @Override
    public void accept(Way way) {
        try {
            List<Coordinate> list = way.getNodes().stream().map(this.coordinateMap::get).toList();
            Coordinate[] array = list.toArray(new Coordinate[list.size()]);
            LineString line = GeometryUtils.GEOMETRY_FACTORY_WGS84.createLineString(array);
            if (!line.isEmpty()) {
                if (!line.isClosed() || way.getTags().containsKey("highway") || way.getTags().containsKey("barrier")) {
                    way.setGeometry((Geometry)line);
                } else {
                    Polygon polygon = GeometryUtils.GEOMETRY_FACTORY_WGS84.createPolygon(line.getCoordinates());
                    way.setGeometry((Geometry)polygon);
                }
            }
        }
        catch (Exception e) {
            logger.debug("Unable to build the geometry for way #" + way.id(), (Throwable)e);
            way.setGeometry(GeometryUtils.GEOMETRY_FACTORY_WGS84.createEmpty(0));
        }
    }
}

