/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.util;

import io.swagger.models.auth.AuthorizationValue;
import io.swagger.models.refs.RefFormat;
import io.swagger.parser.util.ClasspathHelper;
import io.swagger.parser.util.RemoteUrl;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class RefUtils {
    public static String computeDefinitionName(String ref) {
        String plausibleName;
        String definitionPath;
        String[] refParts = ref.split("#/");
        if (refParts.length > 2) {
            throw new RuntimeException("Invalid ref format: " + ref);
        }
        String file = refParts[0];
        String string = definitionPath = refParts.length == 2 ? refParts[1] : null;
        if (definitionPath != null) {
            String[] jsonPathElements = definitionPath.split("/");
            plausibleName = jsonPathElements[jsonPathElements.length - 1];
        } else {
            String[] filePathElements = file.split("/");
            plausibleName = filePathElements[filePathElements.length - 1];
            String[] split = plausibleName.split("\\.");
            plausibleName = split[0];
        }
        return plausibleName;
    }

    public static boolean isAnExternalRefFormat(RefFormat refFormat) {
        return refFormat == RefFormat.URL || refFormat == RefFormat.RELATIVE;
    }

    public static String readExternalUrlRef(String file, RefFormat refFormat, List<AuthorizationValue> auths, String rootPath) {
        String result;
        if (!RefUtils.isAnExternalRefFormat(refFormat)) {
            throw new RuntimeException("Ref is not external");
        }
        try {
            if (refFormat != RefFormat.URL) {
                String url = RefUtils.buildUrl(rootPath, file);
                return RefUtils.readExternalRef(url, RefFormat.URL, auths, null);
            }
            result = RemoteUrl.urlToString(file, auths);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load " + refFormat + " ref: " + file + " path:" + rootPath, e);
        }
        return result;
    }

    public static String buildUrl(String rootPath, String relativePath) {
        int i;
        String[] rootPathParts = rootPath.split("/");
        String[] relPathParts = relativePath.split("/");
        if (rootPath == null || relativePath == null) {
            return null;
        }
        int trimRoot = 0;
        int trimRel = 0;
        if (!"".equals(rootPathParts[rootPathParts.length - 1])) {
            trimRoot = 1;
        }
        for (i = 0; i < rootPathParts.length && "".equals(rootPathParts[i]); ++i) {
            ++trimRel;
        }
        for (i = 0; i < relPathParts.length; ++i) {
            if (".".equals(relPathParts[i])) {
                ++trimRel;
                continue;
            }
            if (!"..".equals(relPathParts[i])) continue;
            ++trimRel;
        }
        Object[] outputParts = new String[rootPathParts.length + relPathParts.length - trimRoot - trimRel];
        System.arraycopy(rootPathParts, 0, outputParts, 0, rootPathParts.length - trimRoot);
        System.arraycopy(relPathParts, trimRel, outputParts, rootPathParts.length - trimRoot + trimRel - 1, relPathParts.length - trimRel);
        return StringUtils.join((Object[])outputParts, (String)"/");
    }

    public static String readExternalRef(String file, RefFormat refFormat, List<AuthorizationValue> auths, Path parentDirectory) {
        String result;
        block31: {
            if (!RefUtils.isAnExternalRefFormat(refFormat)) {
                throw new RuntimeException("Ref is not external");
            }
            result = null;
            try {
                if (refFormat == RefFormat.URL) {
                    result = RemoteUrl.urlToString(file, auths);
                    break block31;
                }
                Path pathToUse = parentDirectory.resolve(file).normalize();
                if (Files.exists(pathToUse, new LinkOption[0])) {
                    try (FileInputStream inputStream = new FileInputStream(pathToUse.toFile());){
                        result = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
                    }
                }
                String url = file;
                url = url.contains("..") ? parentDirectory + url.substring(url.indexOf(".") + 2) : parentDirectory + url.substring(url.indexOf(".") + 1);
                Path pathToUse2 = parentDirectory.resolve(url).normalize();
                if (Files.exists(pathToUse2, new LinkOption[0])) {
                    try (FileInputStream inputStream = new FileInputStream(pathToUse2.toFile());){
                        result = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
                    }
                }
                if (result == null) {
                    result = ClasspathHelper.loadFileFromClasspath(file);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to load " + refFormat + " ref: " + file + " path: " + parentDirectory, e);
            }
        }
        return result;
    }
}

