/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.client.api.ClientGroup;
import io.servicetalk.client.api.ServiceDiscoverer;
import io.servicetalk.client.api.internal.DefaultPartitionedClientGroup;
import io.servicetalk.client.api.internal.partition.PowerSetPartitionMapFactory;
import io.servicetalk.client.api.partition.ClosedPartitionException;
import io.servicetalk.client.api.partition.PartitionAttributes;
import io.servicetalk.client.api.partition.PartitionAttributesBuilder;
import io.servicetalk.client.api.partition.PartitionMapFactory;
import io.servicetalk.client.api.partition.PartitionedServiceDiscovererEvent;
import io.servicetalk.client.api.partition.UnknownPartitionException;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.BiIntFunction;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.RetryStrategies;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.DefaultHttpHeadersFactory;
import io.servicetalk.http.api.DefaultStreamingHttpRequestResponseFactory;
import io.servicetalk.http.api.FilterableReservedStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpHeadersFactory;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.PartitionedHttpClientBuilder;
import io.servicetalk.http.api.ReservedStreamingHttpConnection;
import io.servicetalk.http.api.SingleAddressHttpClientBuilder;
import io.servicetalk.http.api.StreamingHttpClient;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequestResponseFactory;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.netty.DefaultSingleAddressHttpClientBuilder;
import io.servicetalk.http.netty.FilterableClientToClient;
import io.servicetalk.http.netty.HttpExecutionContextBuilder;
import io.servicetalk.transport.api.IoExecutor;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
final class DefaultPartitionedHttpClientBuilder<U, R>
implements PartitionedHttpClientBuilder<U, R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPartitionedHttpClientBuilder.class);
    private final U address;
    private final Function<HttpRequestMetaData, PartitionAttributesBuilder> partitionAttributesBuilderFactory;
    private final Supplier<SingleAddressHttpClientBuilder<U, R>> builderFactory;
    private final HttpExecutionContextBuilder executionContextBuilder = new HttpExecutionContextBuilder();
    private ServiceDiscoverer<U, R, PartitionedServiceDiscovererEvent<R>> serviceDiscoverer;
    @Nullable
    private BiIntFunction<Throwable, ? extends Completable> serviceDiscovererRetryStrategy;
    private int serviceDiscoveryMaxQueueSize = 32;
    @Nullable
    private HttpHeadersFactory headersFactory;
    @Nullable
    private PartitionedHttpClientBuilder.SingleAddressInitializer<U, R> clientInitializer;
    private PartitionMapFactory partitionMapFactory = PowerSetPartitionMapFactory.INSTANCE;

    DefaultPartitionedHttpClientBuilder(U address, Supplier<SingleAddressHttpClientBuilder<U, R>> builderFactory, ServiceDiscoverer<U, R, PartitionedServiceDiscovererEvent<R>> serviceDiscoverer, Function<HttpRequestMetaData, PartitionAttributesBuilder> partitionAttributesBuilderFactory) {
        this.address = Objects.requireNonNull(address);
        this.builderFactory = Objects.requireNonNull(builderFactory);
        this.serviceDiscoverer = Objects.requireNonNull(serviceDiscoverer);
        this.partitionAttributesBuilderFactory = Objects.requireNonNull(partitionAttributesBuilderFactory);
    }

    public StreamingHttpClient buildStreaming() {
        HttpExecutionContext executionContext = this.executionContextBuilder.build();
        BiIntFunction sdRetryStrategy = this.serviceDiscovererRetryStrategy;
        if (sdRetryStrategy == null) {
            sdRetryStrategy = RetryStrategies.retryWithConstantBackoffDeltaJitter(__ -> true, (Duration)DefaultSingleAddressHttpClientBuilder.SD_RETRY_STRATEGY_INIT_DURATION, (Duration)DefaultSingleAddressHttpClientBuilder.SD_RETRY_STRATEGY_JITTER, (Executor)executionContext.executor());
        }
        DefaultSingleAddressHttpClientBuilder.RetryingServiceDiscoverer<U, R, PartitionedServiceDiscovererEvent<R>> psd = new DefaultSingleAddressHttpClientBuilder.RetryingServiceDiscoverer<U, R, PartitionedServiceDiscovererEvent<R>>(this.serviceDiscoverer, sdRetryStrategy);
        DefaultPartitionedClientGroup.PartitionedClientFactory clientFactory = (pa, sd) -> {
            SingleAddressHttpClientBuilder<U, R> builder = Objects.requireNonNull(this.builderFactory.get());
            builder.serviceDiscoverer(sd);
            DefaultSingleAddressHttpClientBuilder.setExecutionContext(builder, executionContext);
            if (this.clientInitializer != null) {
                this.clientInitializer.initialize(pa, builder);
            }
            return builder.buildStreaming();
        };
        Publisher psdEvents = psd.discover(this.address).flatMapConcatIterable(Function.identity());
        HttpHeadersFactory headersFactory = this.headersFactory;
        DefaultPartitionedStreamingHttpClientFilter partitionedClient = new DefaultPartitionedStreamingHttpClientFilter(psdEvents, this.serviceDiscoveryMaxQueueSize, clientFactory, this.partitionAttributesBuilderFactory, (StreamingHttpRequestResponseFactory)new DefaultStreamingHttpRequestResponseFactory(executionContext.bufferAllocator(), headersFactory != null ? headersFactory : DefaultHttpHeadersFactory.INSTANCE, HttpProtocolVersion.HTTP_1_1), executionContext, this.partitionMapFactory);
        LOGGER.debug("Partitioned client created with base strategy {}", (Object)executionContext.executionStrategy());
        return new FilterableClientToClient(partitionedClient, executionContext);
    }

    public PartitionedHttpClientBuilder<U, R> executor(Executor executor) {
        this.executionContextBuilder.executor(executor);
        return this;
    }

    public PartitionedHttpClientBuilder<U, R> ioExecutor(IoExecutor ioExecutor) {
        this.executionContextBuilder.ioExecutor(ioExecutor);
        return this;
    }

    public PartitionedHttpClientBuilder<U, R> bufferAllocator(BufferAllocator allocator) {
        this.executionContextBuilder.bufferAllocator(allocator);
        return this;
    }

    public PartitionedHttpClientBuilder<U, R> serviceDiscoverer(ServiceDiscoverer<U, R, PartitionedServiceDiscovererEvent<R>> serviceDiscoverer) {
        this.serviceDiscoverer = Objects.requireNonNull(serviceDiscoverer);
        return this;
    }

    public PartitionedHttpClientBuilder<U, R> retryServiceDiscoveryErrors(BiIntFunction<Throwable, ? extends Completable> retryStrategy) {
        this.serviceDiscovererRetryStrategy = Objects.requireNonNull(retryStrategy);
        return this;
    }

    public PartitionedHttpClientBuilder<U, R> serviceDiscoveryMaxQueueSize(int serviceDiscoveryMaxQueueSize) {
        this.serviceDiscoveryMaxQueueSize = serviceDiscoveryMaxQueueSize;
        return this;
    }

    public PartitionedHttpClientBuilder<U, R> partitionMapFactory(PartitionMapFactory partitionMapFactory) {
        this.partitionMapFactory = partitionMapFactory;
        return this;
    }

    public PartitionedHttpClientBuilder<U, R> initializer(PartitionedHttpClientBuilder.SingleAddressInitializer<U, R> initializer) {
        this.clientInitializer = Objects.requireNonNull(initializer);
        return this;
    }

    public PartitionedHttpClientBuilder<U, R> executionStrategy(HttpExecutionStrategy strategy) {
        this.executionContextBuilder.executionStrategy(strategy);
        return this;
    }

    public PartitionedHttpClientBuilder<U, R> headersFactory(HttpHeadersFactory headersFactory) {
        this.headersFactory = Objects.requireNonNull(headersFactory);
        return this;
    }

    private static final class NoopPartitionClient
    implements FilterableStreamingHttpClient {
        private final ListenableAsyncCloseable close = AsyncCloseables.emptyAsyncCloseable();
        private final RuntimeException ex;

        NoopPartitionClient(RuntimeException ex) {
            this.ex = ex;
        }

        public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
            return Single.failed((Throwable)this.ex);
        }

        public HttpExecutionContext executionContext() {
            throw this.ex;
        }

        public StreamingHttpResponseFactory httpResponseFactory() {
            throw this.ex;
        }

        public Completable onClose() {
            return this.close.onClose();
        }

        public Completable onClosing() {
            return this.close.onClosing();
        }

        public Completable closeAsync() {
            return this.close.closeAsync();
        }

        public Completable closeAsyncGracefully() {
            return this.close.closeAsyncGracefully();
        }

        public Single<ReservedStreamingHttpConnection> reserveConnection(HttpRequestMetaData metaData) {
            return Single.failed((Throwable)this.ex);
        }

        public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
            throw this.ex;
        }
    }

    private static final class DefaultPartitionedStreamingHttpClientFilter<U, R>
    implements FilterableStreamingHttpClient {
        private static final Function<PartitionAttributes, FilterableStreamingHttpClient> PARTITION_CLOSED = pa -> new NoopPartitionClient((RuntimeException)new ClosedPartitionException(pa, "Partition closed"));
        private static final Function<PartitionAttributes, FilterableStreamingHttpClient> PARTITION_UNKNOWN = pa -> new NoopPartitionClient((RuntimeException)new UnknownPartitionException(pa, "Partition unknown"));
        private final ClientGroup<PartitionAttributes, FilterableStreamingHttpClient> group;
        private final Function<HttpRequestMetaData, PartitionAttributesBuilder> pabf;
        private final HttpExecutionContext executionContext;
        private final StreamingHttpRequestResponseFactory reqRespFactory;

        DefaultPartitionedStreamingHttpClientFilter(Publisher<PartitionedServiceDiscovererEvent<R>> psdEvents, int psdMaxQueueSize, DefaultPartitionedClientGroup.PartitionedClientFactory<U, R, FilterableStreamingHttpClient> clientFactory, Function<HttpRequestMetaData, PartitionAttributesBuilder> pabf, StreamingHttpRequestResponseFactory reqRespFactory, HttpExecutionContext executionContext, PartitionMapFactory partitionMapFactory) {
            this.pabf = pabf;
            this.executionContext = executionContext;
            this.group = new DefaultPartitionedClientGroup(PARTITION_CLOSED, PARTITION_UNKNOWN, clientFactory, partitionMapFactory, psdEvents, psdMaxQueueSize);
            this.reqRespFactory = Objects.requireNonNull(reqRespFactory);
        }

        private FilterableStreamingHttpClient selectClient(HttpRequestMetaData metaData) {
            return (FilterableStreamingHttpClient)this.group.get((Object)this.pabf.apply(metaData).build());
        }

        public Single<? extends FilterableReservedStreamingHttpConnection> reserveConnection(HttpRequestMetaData metaData) {
            return Single.defer(() -> this.selectClient(metaData).reserveConnection(metaData).shareContextOnSubscribe());
        }

        public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
            return Single.defer(() -> this.selectClient((HttpRequestMetaData)request).request(request).shareContextOnSubscribe());
        }

        public HttpExecutionContext executionContext() {
            return this.executionContext;
        }

        public StreamingHttpResponseFactory httpResponseFactory() {
            return this.reqRespFactory;
        }

        public Completable onClose() {
            return this.group.onClose();
        }

        public Completable onClosing() {
            return this.group.onClosing();
        }

        public Completable closeAsync() {
            return this.group.closeAsync();
        }

        public Completable closeAsyncGracefully() {
            return this.group.closeAsyncGracefully();
        }

        public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
            return this.reqRespFactory.newRequest(method, requestTarget);
        }
    }
}

