/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http2.Http2Headers;
import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.http.api.DefaultHttpSetCookie;
import io.servicetalk.http.api.HeaderUtils;
import io.servicetalk.http.api.HttpCookiePair;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpSetCookie;
import io.servicetalk.utils.internal.IllegalCharacterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;

final class NettyH2HeadersToHttpHeaders
implements HttpHeaders {
    private static final byte HT = 9;
    private static final byte DEL = 127;
    private static final byte CONTROL_CHARS_MASK = -32;
    private final Http2Headers nettyHeaders;
    private final boolean validateCookies;
    private final boolean validateValues;

    NettyH2HeadersToHttpHeaders(Http2Headers nettyHeaders, boolean validateCookies, boolean validateValues) {
        this.nettyHeaders = nettyHeaders;
        this.validateCookies = validateCookies;
        this.validateValues = validateValues;
    }

    Http2Headers nettyHeaders() {
        return this.nettyHeaders;
    }

    @Nullable
    public CharSequence get(CharSequence name) {
        return (CharSequence)this.nettyHeaders.get((Object)name);
    }

    @Nullable
    public CharSequence getAndRemove(CharSequence name) {
        return (CharSequence)this.nettyHeaders.getAndRemove((Object)name);
    }

    public Iterator<? extends CharSequence> valuesIterator(CharSequence name) {
        return this.nettyHeaders.valueIterator(name);
    }

    public boolean contains(CharSequence name, CharSequence value) {
        return this.nettyHeaders.contains((Object)name, (Object)value);
    }

    public boolean containsIgnoreCase(CharSequence name, CharSequence value) {
        return this.nettyHeaders.contains(name, value, true);
    }

    public int size() {
        return this.nettyHeaders.size();
    }

    public boolean isEmpty() {
        return this.nettyHeaders.isEmpty();
    }

    public Set<? extends CharSequence> names() {
        return this.nettyHeaders.names();
    }

    public HttpHeaders add(CharSequence name, CharSequence value) {
        this.nettyHeaders.add((Object)name, (Object)this.validateHeaderValue(value));
        return this;
    }

    public HttpHeaders add(CharSequence name, Iterable<? extends CharSequence> values) {
        this.nettyHeaders.add((Object)name, this.validateHeaderValue(values));
        return this;
    }

    public HttpHeaders add(CharSequence name, CharSequence ... values) {
        this.nettyHeaders.add((Object)name, (Object[])this.validateHeaderValue(values));
        return this;
    }

    public HttpHeaders add(HttpHeaders headers) {
        for (Map.Entry entry : headers) {
            this.nettyHeaders.add(entry.getKey(), (Object)this.validateHeaderValue((CharSequence)entry.getValue()));
        }
        return this;
    }

    public HttpHeaders set(CharSequence name, CharSequence value) {
        this.nettyHeaders.set((Object)name, (Object)this.validateHeaderValue(value));
        return this;
    }

    public HttpHeaders set(CharSequence name, Iterable<? extends CharSequence> values) {
        this.nettyHeaders.set((Object)name, this.validateHeaderValue(values));
        return this;
    }

    public HttpHeaders set(CharSequence name, CharSequence ... values) {
        this.nettyHeaders.set((Object)name, (Object[])this.validateHeaderValue(values));
        return this;
    }

    public boolean remove(CharSequence name) {
        return this.nettyHeaders.remove((Object)name);
    }

    public boolean remove(CharSequence name, CharSequence value) {
        int sizeBefore = this.size();
        Iterator valuesItr = this.nettyHeaders.valueIterator(name);
        while (valuesItr.hasNext()) {
            CharSequence next = (CharSequence)valuesItr.next();
            if (!CharSequences.contentEquals((CharSequence)next, (CharSequence)value)) continue;
            valuesItr.remove();
        }
        return sizeBefore != this.size();
    }

    public boolean removeIgnoreCase(CharSequence name, CharSequence value) {
        int sizeBefore = this.size();
        Iterator valuesItr = this.nettyHeaders.valueIterator(name);
        while (valuesItr.hasNext()) {
            CharSequence next = (CharSequence)valuesItr.next();
            if (!CharSequences.contentEqualsIgnoreCase((CharSequence)next, (CharSequence)value)) continue;
            valuesItr.remove();
        }
        return sizeBefore != this.size();
    }

    public HttpHeaders clear() {
        this.nettyHeaders.clear();
        return this;
    }

    public Iterator<Map.Entry<CharSequence, CharSequence>> iterator() {
        return this.nettyHeaders.iterator();
    }

    public String toString() {
        return this.toString(HeaderUtils.DEFAULT_HEADER_FILTER);
    }

    @Nullable
    public HttpCookiePair getCookie(CharSequence name) {
        Iterator valueItr = this.nettyHeaders.valueIterator((CharSequence)HttpHeaderNames.COOKIE);
        while (valueItr.hasNext()) {
            HttpCookiePair cookiePair = HeaderUtils.parseCookiePair((CharSequence)((CharSequence)valueItr.next()), (CharSequence)name);
            if (cookiePair == null) continue;
            return cookiePair;
        }
        return null;
    }

    @Nullable
    public HttpSetCookie getSetCookie(CharSequence name) {
        Iterator valueItr = this.nettyHeaders.valueIterator((CharSequence)HttpHeaderNames.SET_COOKIE);
        while (valueItr.hasNext()) {
            HttpSetCookie setCookie = HeaderUtils.parseSetCookie((CharSequence)((CharSequence)valueItr.next()), (CharSequence)name, (boolean)this.validateCookies);
            if (setCookie == null) continue;
            return setCookie;
        }
        return null;
    }

    public Iterator<? extends HttpCookiePair> getCookiesIterator() {
        Iterator valueItr = this.nettyHeaders.valueIterator((CharSequence)HttpHeaderNames.COOKIE);
        return valueItr.hasNext() ? new CookiesIterator(valueItr) : Collections.emptyIterator();
    }

    public Iterator<? extends HttpCookiePair> getCookiesIterator(CharSequence name) {
        return new CookiesByNameIterator(this.nettyHeaders.valueIterator((CharSequence)HttpHeaderNames.COOKIE), name);
    }

    public Iterator<? extends HttpSetCookie> getSetCookiesIterator() {
        Iterator valueItr = this.nettyHeaders.valueIterator((CharSequence)HttpHeaderNames.SET_COOKIE);
        return valueItr.hasNext() ? new SetCookiesIterator(valueItr) : Collections.emptyIterator();
    }

    public Iterator<? extends HttpSetCookie> getSetCookiesIterator(CharSequence name) {
        Iterator valueItr = this.nettyHeaders.valueIterator((CharSequence)HttpHeaderNames.SET_COOKIE);
        while (valueItr.hasNext()) {
            HttpSetCookie setCookie = HeaderUtils.parseSetCookie((CharSequence)((CharSequence)valueItr.next()), (CharSequence)name, (boolean)this.validateCookies);
            if (setCookie == null) continue;
            return new SetCookiesByNameIterator(valueItr, setCookie);
        }
        return Collections.emptyIterator();
    }

    public Iterator<? extends HttpSetCookie> getSetCookiesIterator(CharSequence name, CharSequence domain, CharSequence path) {
        Iterator valueItr = this.nettyHeaders.valueIterator((CharSequence)HttpHeaderNames.SET_COOKIE);
        while (valueItr.hasNext()) {
            HttpSetCookie setCookie = HeaderUtils.parseSetCookie((CharSequence)((CharSequence)valueItr.next()), (CharSequence)name, (boolean)this.validateCookies);
            if (setCookie == null || !HeaderUtils.domainMatches((CharSequence)domain, (CharSequence)setCookie.domain()) || !HeaderUtils.pathMatches((CharSequence)path, (CharSequence)setCookie.path())) continue;
            return new SetCookiesByNameDomainPathIterator(valueItr, setCookie, domain, path);
        }
        return Collections.emptyIterator();
    }

    public HttpHeaders addCookie(HttpCookiePair cookie) {
        this.add(io.servicetalk.http.api.HttpHeaderNames.COOKIE, cookie.encoded());
        return this;
    }

    public HttpHeaders addSetCookie(HttpSetCookie cookie) {
        this.add(io.servicetalk.http.api.HttpHeaderNames.SET_COOKIE, cookie.encoded());
        return this;
    }

    public boolean removeCookies(CharSequence name) {
        Iterator valuesItr = this.nettyHeaders.valueIterator((CharSequence)HttpHeaderNames.COOKIE);
        ArrayList<CharSequence> cookiesToAdd = null;
        int sizeBefore = this.size();
        while (valuesItr.hasNext()) {
            CharSequence newHeaderValue = HeaderUtils.removeCookiePairs((CharSequence)((CharSequence)valuesItr.next()), (CharSequence)name);
            if (newHeaderValue == null) continue;
            if (newHeaderValue.length() != 0) {
                if (cookiesToAdd == null) {
                    cookiesToAdd = new ArrayList<CharSequence>(4);
                }
                cookiesToAdd.add(newHeaderValue);
            }
            valuesItr.remove();
        }
        if (cookiesToAdd != null) {
            for (CharSequence cookies : cookiesToAdd) {
                this.nettyHeaders.add((Object)HttpHeaderNames.COOKIE, (Object)cookies);
            }
            return true;
        }
        return sizeBefore != this.size();
    }

    public boolean removeSetCookies(CharSequence name) {
        int sizeBefore = this.size();
        Iterator valueItr = this.nettyHeaders.valueIterator((CharSequence)HttpHeaderNames.SET_COOKIE);
        while (valueItr.hasNext()) {
            if (!HeaderUtils.isSetCookieNameMatches((CharSequence)((CharSequence)valueItr.next()), (CharSequence)name)) continue;
            valueItr.remove();
        }
        return sizeBefore != this.size();
    }

    public boolean removeSetCookies(CharSequence name, CharSequence domain, CharSequence path) {
        int sizeBefore = this.size();
        Iterator valueItr = this.nettyHeaders.valueIterator((CharSequence)HttpHeaderNames.SET_COOKIE);
        while (valueItr.hasNext()) {
            HttpSetCookie setCookie = HeaderUtils.parseSetCookie((CharSequence)((CharSequence)valueItr.next()), (CharSequence)name, (boolean)false);
            if (setCookie == null || !HeaderUtils.domainMatches((CharSequence)domain, (CharSequence)setCookie.domain()) || !HeaderUtils.pathMatches((CharSequence)path, (CharSequence)setCookie.path())) continue;
            valueItr.remove();
        }
        return sizeBefore != this.size();
    }

    private CharSequence validateHeaderValue(CharSequence value) {
        if (this.validateValues) {
            CharSequences.forEachByte((CharSequence)value, NettyH2HeadersToHttpHeaders::validateHeaderValue);
        }
        return value;
    }

    private Iterable<? extends CharSequence> validateHeaderValue(Iterable<? extends CharSequence> values) {
        if (this.validateValues) {
            for (CharSequence charSequence : values) {
                CharSequences.forEachByte((CharSequence)charSequence, NettyH2HeadersToHttpHeaders::validateHeaderValue);
            }
        }
        return values;
    }

    private CharSequence[] validateHeaderValue(CharSequence ... values) {
        if (this.validateValues) {
            for (CharSequence v : values) {
                CharSequences.forEachByte((CharSequence)v, NettyH2HeadersToHttpHeaders::validateHeaderValue);
            }
        }
        return values;
    }

    private static boolean validateHeaderValue(byte value) {
        if ((value & 0xFFFFFFE0) == 0 && value != 9 || value == 127) {
            throw new IllegalCharacterException(value, "(VCHAR / obs-text) [ 1*(SP / HTAB) (VCHAR / obs-text) ]");
        }
        return true;
    }

    private final class SetCookiesByNameDomainPathIterator
    implements Iterator<HttpSetCookie> {
        private final Iterator<CharSequence> valueItr;
        private final CharSequence domain;
        private final CharSequence path;
        @Nullable
        private HttpSetCookie next;

        SetCookiesByNameDomainPathIterator(Iterator<CharSequence> valueItr, HttpSetCookie next, CharSequence domain, CharSequence path) {
            this.valueItr = valueItr;
            this.domain = domain;
            this.path = path;
            this.next = next;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public HttpSetCookie next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            HttpSetCookie currentCookie = this.next;
            this.next = null;
            while (this.valueItr.hasNext()) {
                HttpSetCookie setCookie = HeaderUtils.parseSetCookie((CharSequence)this.valueItr.next(), (CharSequence)currentCookie.name(), (boolean)NettyH2HeadersToHttpHeaders.this.validateCookies);
                if (setCookie == null || !HeaderUtils.domainMatches((CharSequence)this.domain, (CharSequence)setCookie.domain()) || !HeaderUtils.pathMatches((CharSequence)this.path, (CharSequence)setCookie.path())) continue;
                this.next = setCookie;
                break;
            }
            return currentCookie;
        }

        @Override
        public void remove() {
            this.valueItr.remove();
        }
    }

    private final class SetCookiesByNameIterator
    implements Iterator<HttpSetCookie> {
        private final Iterator<CharSequence> valueItr;
        @Nullable
        private HttpSetCookie next;

        SetCookiesByNameIterator(Iterator<CharSequence> valueItr, HttpSetCookie next) {
            this.valueItr = valueItr;
            this.next = next;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public HttpSetCookie next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            HttpSetCookie currentCookie = this.next;
            this.next = null;
            while (this.valueItr.hasNext()) {
                this.next = HeaderUtils.parseSetCookie((CharSequence)this.valueItr.next(), (CharSequence)currentCookie.name(), (boolean)NettyH2HeadersToHttpHeaders.this.validateCookies);
                if (this.next == null) continue;
                break;
            }
            return currentCookie;
        }

        @Override
        public void remove() {
            this.valueItr.remove();
        }
    }

    private final class SetCookiesIterator
    implements Iterator<HttpSetCookie> {
        private final Iterator<CharSequence> valueItr;

        SetCookiesIterator(Iterator<CharSequence> valueItr) {
            this.valueItr = valueItr;
        }

        @Override
        public boolean hasNext() {
            return this.valueItr.hasNext();
        }

        @Override
        public HttpSetCookie next() {
            return DefaultHttpSetCookie.parseSetCookie((CharSequence)this.valueItr.next(), (boolean)NettyH2HeadersToHttpHeaders.this.validateCookies);
        }

        @Override
        public void remove() {
            this.valueItr.remove();
        }
    }

    private static final class CookiesByNameIterator
    extends HeaderUtils.CookiesByNameIterator {
        private final Iterator<CharSequence> valueItr;
        @Nullable
        private CharSequence headerValue;

        CookiesByNameIterator(Iterator<CharSequence> valueItr, CharSequence name) {
            super(name);
            this.valueItr = valueItr;
            if (valueItr.hasNext()) {
                this.headerValue = valueItr.next();
                this.initNext(this.headerValue);
            }
        }

        @Nullable
        protected CharSequence cookieHeaderValue() {
            return this.headerValue;
        }

        protected void advanceCookieHeaderValue() {
            this.headerValue = this.valueItr.hasNext() ? this.valueItr.next() : null;
        }
    }

    private static final class CookiesIterator
    extends HeaderUtils.CookiesIterator {
        private final Iterator<CharSequence> valueItr;
        @Nullable
        private CharSequence headerValue;

        CookiesIterator(Iterator<CharSequence> valueItr) {
            this.valueItr = valueItr;
            if (valueItr.hasNext()) {
                this.headerValue = valueItr.next();
                this.initNext(this.headerValue);
            }
        }

        @Nullable
        protected CharSequence cookieHeaderValue() {
            return this.headerValue;
        }

        protected void advanceCookieHeaderValue() {
            this.headerValue = this.valueItr.hasNext() ? this.valueItr.next() : null;
        }
    }
}

