/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.http.api.StreamingHttpRequestResponseFactory;
import io.servicetalk.http.netty.AbstractStreamingHttpConnection;
import io.servicetalk.http.netty.H1ProtocolConfig;
import io.servicetalk.http.netty.NettyPipelinedConnection;
import io.servicetalk.transport.netty.internal.FlushStrategy;
import io.servicetalk.transport.netty.internal.NettyConnection;
import io.servicetalk.transport.netty.internal.WriteDemandEstimators;
import javax.annotation.Nullable;

final class PipelinedStreamingHttpConnection
extends AbstractStreamingHttpConnection<NettyPipelinedConnection<Object, Object>> {
    PipelinedStreamingHttpConnection(NettyConnection<Object, Object> connection, H1ProtocolConfig config, StreamingHttpRequestResponseFactory reqRespFactory, boolean allowDropTrailersReadFromTransport) {
        super(new NettyPipelinedConnection<Object, Object>(connection, config.maxPipelinedRequests()), config.maxPipelinedRequests(), reqRespFactory, config.headersFactory(), allowDropTrailersReadFromTransport);
    }

    @Override
    protected Publisher<Object> writeAndRead(Publisher<Object> requestStream, @Nullable FlushStrategy flushStrategy) {
        if (flushStrategy == null) {
            return ((NettyPipelinedConnection)this.connection).write(requestStream);
        }
        return Publisher.defer(() -> {
            Cancellable resetFlushStrategy = ((NettyPipelinedConnection)this.connection).updateFlushStrategy((prev, isOriginal) -> isOriginal ? flushStrategy : prev);
            return ((NettyPipelinedConnection)this.connection).write(requestStream, ((NettyPipelinedConnection)this.connection)::defaultFlushStrategy, WriteDemandEstimators::newDefaultEstimator).afterFinally(() -> ((Cancellable)resetFlushStrategy).cancel());
        });
    }
}

