/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.proj;

import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import mil.nga.proj.Projection;
import mil.nga.proj.ProjectionFactory;
import mil.nga.proj.ProjectionTransform;
import org.locationtech.proj4j.ProjCoordinate;

public class Project {
    private static final String HELP_ARG = "-help";
    private static final String FROM_PROMPT = "From Projection: ";
    private static final String TO_PROMPT = "To Projection: ";
    private static final String COORDINATES_PROMPT = "Coordinate(s): ";
    private static final String INVERSE_COMMAND = "Inverse";
    private static ProjectionTransform transform = null;

    public static void main(String[] args) {
        boolean valid = true;
        Projection fromProjection = null;
        StringBuilder builder = null;
        block4: for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equalsIgnoreCase(HELP_ARG)) {
                valid = false;
                break;
            }
            switch (i) {
                case 0: {
                    fromProjection = Project.createProjection(arg);
                    valid = false;
                    continue block4;
                }
                case 1: {
                    Projection toProjection = Project.createProjection(arg);
                    if (fromProjection == null || toProjection == null) continue block4;
                    transform = fromProjection.getTransformation(toProjection);
                    valid = true;
                    continue block4;
                }
                default: {
                    if (builder == null) {
                        builder = new StringBuilder();
                    } else {
                        builder.append(" ");
                    }
                    builder.append(arg);
                }
            }
        }
        List<ProjCoordinate> coordinates = null;
        if (valid && builder != null) {
            coordinates = Project.createCoordinates(builder.toString());
            boolean bl = valid = !coordinates.isEmpty();
        }
        if (!valid) {
            Project.printUsage();
        } else if (coordinates == null) {
            Project.commandPrompt();
        } else {
            Project.printTransform();
            Project.project(coordinates);
            System.out.println();
        }
    }

    private static Projection createProjection(String value) {
        Projection projection = null;
        try {
            if (value.contains("[") && value.contains("]")) {
                projection = ProjectionFactory.getProjectionByDefinition(value);
            } else if (value.contains("+")) {
                projection = ProjectionFactory.getProjectionByParams(value);
            } else {
                String authority = "EPSG";
                String code = value;
                String[] parts = code.split(":");
                if (parts.length == 2) {
                    authority = parts[0];
                    code = parts[1];
                }
                projection = ProjectionFactory.getProjection(authority, code);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (projection == null) {
            System.out.println("Error: Invalid projection '" + value + "'");
        }
        return projection;
    }

    private static List<ProjCoordinate> createCoordinates(String value) {
        ArrayList<ProjCoordinate> coordinates = new ArrayList<ProjCoordinate>();
        if (value != null) {
            value = value.trim();
            String[] parts = null;
            if (value.startsWith("[")) {
                parts = value.split("\\[|\\]");
            } else if (value.contains(",")) {
                value = value.replaceAll("\\s*,\\s*", ",");
                parts = value.split("\\s+");
            } else {
                parts = new String[]{value};
            }
            for (String part : parts) {
                ProjCoordinate coordinate;
                if ((part = part.trim()).isEmpty() || part.equals(",") || (coordinate = Project.createCoordinate(part)) == null) continue;
                coordinates.add(coordinate);
            }
        }
        return coordinates;
    }

    private static ProjCoordinate createCoordinate(String value) {
        ProjCoordinate coordinate = null;
        String[] parts = value.split("\\s*,\\s*|\\s+");
        if (parts.length == 2 || parts.length == 3) {
            try {
                double x = Double.parseDouble(parts[0]);
                double y = Double.parseDouble(parts[1]);
                if (parts.length == 3) {
                    double z = Double.parseDouble(parts[2]);
                    coordinate = new ProjCoordinate(x, y, z);
                } else {
                    coordinate = new ProjCoordinate(x, y);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (coordinate == null) {
            System.out.println("Error: Invalid coordinate '" + value + "'");
        }
        return coordinate;
    }

    public static void project(List<ProjCoordinate> coordinates) {
        System.out.println();
        for (ProjCoordinate coordinate : coordinates) {
            System.out.print(coordinate.toShortString() + " -> ");
            ProjCoordinate transformed = transform.transform(coordinate);
            System.out.println(transformed.toShortString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void commandPrompt() {
        try (Scanner scanner = new Scanner(System.in);){
            if (transform == null) {
                Projection fromProjection = null;
                System.out.println();
                System.out.print(FROM_PROMPT);
                StringBuilder proj = new StringBuilder();
                int openCount = 0;
                int closeCount = 0;
                while (scanner.hasNextLine()) {
                    block10: {
                        String input = scanner.nextLine().trim();
                        proj.append(input);
                        if ((openCount += input.length() - input.replaceAll("\\[", "").length()) > 0) {
                            closeCount += input.length() - input.replaceAll("\\]", "").length();
                        }
                        if (closeCount < openCount) continue;
                        try {
                            if (fromProjection == null) {
                                fromProjection = Project.createProjection(proj.toString());
                                break block10;
                            }
                            Projection toProjection = Project.createProjection(proj.toString());
                            transform = fromProjection.getTransformation(toProjection);
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    proj = new StringBuilder();
                    openCount = 0;
                    closeCount = 0;
                    System.out.println();
                    if (fromProjection == null) {
                        System.out.print(FROM_PROMPT);
                        continue;
                    }
                    System.out.print(TO_PROMPT);
                }
            }
            Project.printTransform();
            Project.commandPrompt(scanner);
        }
    }

    private static void commandPrompt(Scanner scanner) {
        System.out.println();
        System.out.println("Enter 'Inverse' to invert transformation");
        System.out.println();
        System.out.print(COORDINATES_PROMPT);
        while (scanner.hasNextLine()) {
            try {
                String line = scanner.nextLine();
                if (line != null) {
                    if ((line = line.trim()).equalsIgnoreCase(INVERSE_COMMAND)) {
                        transform = transform.getInverseTransformation();
                        Project.printTransform();
                    } else {
                        List<ProjCoordinate> coordinates = Project.createCoordinates(line);
                        if (!coordinates.isEmpty()) {
                            Project.project(coordinates);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println();
            System.out.print(COORDINATES_PROMPT);
        }
    }

    private static void printTransform() {
        Projection from = transform.getFromProjection();
        Projection to = transform.getToProjection();
        String fromCode = from.getCode();
        String toCode = to.getCode();
        System.out.println();
        if (!fromCode.isEmpty() && !toCode.isEmpty()) {
            System.out.println(from + " -> " + to);
        } else {
            if (!fromCode.isEmpty()) {
                System.out.println(from);
            } else if (from.getDefinition() != null) {
                System.out.println(from.getDefinition());
            } else {
                System.out.println(from.getCrs().getParameterString());
            }
            System.out.println("->");
            if (!toCode.isEmpty()) {
                System.out.println(to);
            } else if (to.getDefinition() != null) {
                System.out.println(to.getDefinition());
            } else {
                System.out.println(to.getCrs().getParameterString());
            }
        }
    }

    private static void printUsage() {
        System.out.println();
        System.out.println("USAGE");
        System.out.println();
        System.out.println("\t[from_projection to_projection [coordinates]]");
        System.out.println();
        System.out.println("DESCRIPTION");
        System.out.println();
        System.out.println("\tTransform coordinates between projections");
        System.out.println();
        System.out.println("\tfrom_projection");
        System.out.println("\t\tProjection to transform from (EPSG_CODE, AUTHORITY:CODE, PROJ_PARAMS, or OGC_WKT)");
        System.out.println("\t\t\tExamples: 4326, EPSG:4326, \"+proj=longlat ...\", \"GEOGCRS[...\"");
        System.out.println();
        System.out.println("\tto_projection");
        System.out.println("\t\tProjection to transform to (EPSG_CODE, AUTHORITY:CODE, PROJ_PARAMS, or OGC_WKT)");
        System.out.println("\t\t\tExamples: 3857, EPSG:3857, \"+proj=merc ...\", \"PROJCRS[...\"");
        System.out.println();
        System.out.println("\tcoordinates");
        System.out.println("\t\tCoordinate(s) to transform between projections ([x, y], [x, y, z])");
        System.out.println("\t\t\tExamples: [-110.0, 75.0], [95.0, -20.0, 0.0]");
        System.out.println();
    }
}

