/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.misc;

import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.DataPersisterManager;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseFieldConfig;
import com.j256.ormlite.misc.JavaxPersistenceConfigurer;
import java.lang.reflect.Field;
import java.util.Collection;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Version;

public class JavaxPersistenceImpl
implements JavaxPersistenceConfigurer {
    @Override
    public DatabaseFieldConfig createFieldConfig(DatabaseType databaseType, Field field) {
        Column columnAnnotation = field.getAnnotation(Column.class);
        Basic basicAnnotation = field.getAnnotation(Basic.class);
        Id idAnnotation = field.getAnnotation(Id.class);
        GeneratedValue generatedValueAnnotation = field.getAnnotation(GeneratedValue.class);
        OneToOne oneToOneAnnotation = field.getAnnotation(OneToOne.class);
        OneToMany oneToManyAnnotation = field.getAnnotation(OneToMany.class);
        ManyToOne manyToOneAnnotation = field.getAnnotation(ManyToOne.class);
        JoinColumn joinColumnAnnotation = field.getAnnotation(JoinColumn.class);
        Enumerated enumeratedAnnotation = field.getAnnotation(Enumerated.class);
        Version versionAnnotation = field.getAnnotation(Version.class);
        if (columnAnnotation == null && basicAnnotation == null && idAnnotation == null && oneToOneAnnotation == null && oneToManyAnnotation == null && manyToOneAnnotation == null && enumeratedAnnotation == null && versionAnnotation == null) {
            return null;
        }
        DatabaseFieldConfig config = new DatabaseFieldConfig();
        config.setJavaxEntity(true);
        String fieldName = field.getName();
        if (databaseType.isEntityNamesMustBeUpCase()) {
            fieldName = databaseType.upCaseEntityName(fieldName);
        }
        config.setFieldName(fieldName);
        if (columnAnnotation != null) {
            if (this.stringNotEmpty(columnAnnotation.name())) {
                config.setColumnName(columnAnnotation.name());
            }
            if (this.stringNotEmpty(columnAnnotation.columnDefinition())) {
                config.setColumnDefinition(columnAnnotation.columnDefinition());
            }
            config.setWidth(columnAnnotation.length());
            config.setCanBeNull(columnAnnotation.nullable());
            config.setUnique(columnAnnotation.unique());
        }
        if (basicAnnotation != null) {
            config.setCanBeNull(basicAnnotation.optional());
        }
        if (idAnnotation != null) {
            if (generatedValueAnnotation == null) {
                config.setId(true);
            } else {
                config.setGeneratedId(true);
            }
        }
        if (oneToManyAnnotation != null) {
            FetchType fetchType;
            config.setForeignCollection(true);
            String mappedBy = oneToManyAnnotation.mappedBy();
            if (this.stringNotEmpty(mappedBy)) {
                config.setForeignCollectionForeignFieldName(mappedBy);
            }
            if ((fetchType = oneToManyAnnotation.fetch()) == FetchType.EAGER) {
                config.setForeignCollectionEager(true);
            }
        } else if (oneToOneAnnotation != null || manyToOneAnnotation != null) {
            if (Collection.class.isAssignableFrom(field.getType()) || ForeignCollection.class.isAssignableFrom(field.getType())) {
                FetchType fetchType;
                config.setForeignCollection(true);
                if (joinColumnAnnotation != null && this.stringNotEmpty(joinColumnAnnotation.name())) {
                    config.setForeignCollectionColumnName(joinColumnAnnotation.name());
                }
                if (manyToOneAnnotation != null && (fetchType = manyToOneAnnotation.fetch()) != null && fetchType == FetchType.EAGER) {
                    config.setForeignCollectionEager(true);
                }
            } else {
                config.setForeign(true);
                if (joinColumnAnnotation != null) {
                    if (this.stringNotEmpty(joinColumnAnnotation.name())) {
                        config.setColumnName(joinColumnAnnotation.name());
                    }
                    config.setCanBeNull(joinColumnAnnotation.nullable());
                    config.setUnique(joinColumnAnnotation.unique());
                }
            }
        }
        if (enumeratedAnnotation != null) {
            EnumType enumType = enumeratedAnnotation.value();
            if (enumType != null && enumType == EnumType.STRING) {
                config.setDataType(DataType.ENUM_STRING);
            } else {
                config.setDataType(DataType.ENUM_INTEGER);
            }
        }
        if (versionAnnotation != null) {
            config.setVersion(true);
        }
        if (config.getDataPersister() == null) {
            config.setDataPersister(DataPersisterManager.lookupForField(field));
        }
        config.setUseGetSet(DatabaseFieldConfig.findGetMethod(field, databaseType, false) != null && DatabaseFieldConfig.findSetMethod(field, databaseType, false) != null);
        return config;
    }

    @Override
    public String getEntityName(Class<?> clazz) {
        Entity entityAnnotation = clazz.getAnnotation(Entity.class);
        Table tableAnnotation = clazz.getAnnotation(Table.class);
        if (entityAnnotation != null && this.stringNotEmpty(entityAnnotation.name())) {
            return entityAnnotation.name();
        }
        if (tableAnnotation != null && this.stringNotEmpty(tableAnnotation.name())) {
            return tableAnnotation.name();
        }
        return null;
    }

    private boolean stringNotEmpty(String value) {
        return value != null && value.length() > 0;
    }
}

