/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.user;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.user.UserColumn;
import mil.nga.geopackage.user.UserCoreRow;
import mil.nga.geopackage.user.UserTable;

public class UserRowSync<TColumn extends UserColumn, TTable extends UserTable<TColumn>, TRow extends UserCoreRow<TColumn, TTable>> {
    protected Lock lock = new ReentrantLock();
    protected Map<Long, RowCondition> rows = new HashMap<Long, RowCondition>();

    protected UserRowSync() {
    }

    public TRow getRowOrLock(long id) {
        TRow row = null;
        this.lock.lock();
        try {
            RowCondition rowCondition = this.rows.get(id);
            if (rowCondition != null) {
                row = rowCondition.row;
                if (row == null) {
                    rowCondition.condition.await();
                    row = rowCondition.row;
                }
            } else {
                rowCondition = new RowCondition();
                rowCondition.condition = this.lock.newCondition();
                this.rows.put(id, rowCondition);
            }
        }
        catch (InterruptedException e) {
            throw new GeoPackageException("Interruption obtaining cached row or row lock. id: " + id, e);
        }
        finally {
            this.lock.unlock();
        }
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRow(long id, TRow row) {
        this.lock.lock();
        try {
            RowCondition rowCondition = this.rows.remove(id);
            if (rowCondition != null) {
                rowCondition.row = row;
                rowCondition.condition.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected class RowCondition {
        private Condition condition;
        private TRow row;

        protected RowCondition() {
        }
    }
}

