/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.plugins.model.PluginType;
import org.apache.logging.log4j.util.Cast;

public class Node {
    public static final String CORE_NAMESPACE = "Core";
    public static final Key<Node> CURRENT_NODE = new Key<Node>(){};
    private Node parent;
    private final String name;
    private String value;
    private final PluginType<?> type;
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final List<Node> children = new ArrayList<Node>();
    private Object object;

    public Node(Node parent, String name, PluginType<?> type) {
        this.parent = parent;
        this.name = name;
        this.type = type;
    }

    public Node() {
        this.parent = null;
        this.name = null;
        this.type = null;
    }

    public Node(Node node) {
        this.parent = node.parent;
        this.name = node.name;
        this.type = node.type;
        this.attributes.putAll(node.getAttributes());
        this.value = node.getValue();
        for (Node child : node.getChildren()) {
            this.children.add(new Node(child));
        }
        this.object = node.object;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public List<Node> getChildren() {
        return this.children;
    }

    public void addChild(Node child) {
        this.children.add(child);
        child.setParent(this);
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Node getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public void setObject(Object obj) {
        this.object = obj;
    }

    public <T> T getObject() {
        return (T)Cast.cast((Object)this.object);
    }

    public <T> T getObject(Class<T> clazz) {
        return clazz.cast(this.object);
    }

    public boolean isInstanceOf(Class<?> clazz) {
        return clazz.isInstance(this.object);
    }

    public PluginType<?> getType() {
        return this.type;
    }

    public Optional<String> removeMatchingAttribute(String name, Collection<String> aliases) {
        Iterator<Map.Entry<String, String>> iterator = this.attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String key = entry.getKey();
            if (!key.equalsIgnoreCase(name)) {
                if (!aliases.stream().anyMatch(key::equalsIgnoreCase)) continue;
            }
            iterator.remove();
            return Optional.ofNullable(entry.getValue());
        }
        return Optional.empty();
    }

    public String toString() {
        if (this.object == null) {
            return "null";
        }
        return this.type.isObjectPrintable() ? this.object.toString() : this.type.getPluginClass().getName() + " with name " + this.name;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements Supplier<Node> {
        private final Map<String, String> attributes = new LinkedHashMap<String, String>();
        private final List<Builder> children = new ArrayList<Builder>();
        private String name;
        private String value;
        private PluginType<?> pluginType;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setValue(String value) {
            this.value = value;
            return this;
        }

        public Builder setPluginType(PluginType<?> pluginType) {
            this.pluginType = pluginType;
            return this;
        }

        public Builder setAttribute(String name, String value) {
            this.attributes.put(name, value);
            return this;
        }

        public Builder setAttributes(Map<String, String> attributes) {
            this.attributes.putAll(attributes);
            return this;
        }

        public Builder addChild(Consumer<Builder> child) {
            Builder builder = new Builder();
            child.accept(builder);
            this.children.add(builder);
            return this;
        }

        @Override
        public Node get() {
            Node node = new Node(null, this.name, this.pluginType);
            node.setValue(this.value);
            node.attributes.putAll(this.attributes);
            for (Builder child : this.children) {
                node.addChild(child.get());
            }
            return node;
        }
    }
}

