/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.xml;

import java.io.InputStream;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.baremaps.database.collection.DataMap;
import org.apache.baremaps.openstreetmap.OsmReader;
import org.apache.baremaps.openstreetmap.function.CoordinateMapBuilder;
import org.apache.baremaps.openstreetmap.function.EntityGeometryBuilder;
import org.apache.baremaps.openstreetmap.function.EntityProjectionTransformer;
import org.apache.baremaps.openstreetmap.function.ReferenceMapBuilder;
import org.apache.baremaps.openstreetmap.model.Entity;
import org.apache.baremaps.openstreetmap.xml.XmlEntitySpliterator;
import org.apache.baremaps.stream.ConsumerUtils;
import org.locationtech.jts.geom.Coordinate;

public class XmlEntityReader
implements OsmReader<Entity> {
    private boolean geometry = false;
    private int srid = 4326;
    private DataMap<Long, Coordinate> coordinateMap;
    private DataMap<Long, List<Long>> referenceMap;

    public boolean geometries() {
        return this.geometry;
    }

    public XmlEntityReader geometries(boolean geometries) {
        this.geometry = geometries;
        return this;
    }

    public int projection() {
        return this.srid;
    }

    public XmlEntityReader projection(int srid) {
        this.srid = srid;
        return this;
    }

    public DataMap<Long, Coordinate> coordinateMap() {
        return this.coordinateMap;
    }

    public XmlEntityReader coordinateMap(DataMap<Long, Coordinate> coordinateMap) {
        this.coordinateMap = coordinateMap;
        return this;
    }

    public DataMap<Long, List<Long>> referenceMap() {
        return this.referenceMap;
    }

    public XmlEntityReader referenceMap(DataMap<Long, List<Long>> referenceMap) {
        this.referenceMap = referenceMap;
        return this;
    }

    @Override
    public Stream<Entity> stream(InputStream input) {
        Stream<Entity> entities = StreamSupport.stream(new XmlEntitySpliterator(input), false);
        if (this.geometry) {
            CoordinateMapBuilder coordinateMapBuilder = new CoordinateMapBuilder(this.coordinateMap);
            ReferenceMapBuilder referenceMapBuilder = new ReferenceMapBuilder(this.referenceMap);
            EntityGeometryBuilder entityGeometryBuilder = new EntityGeometryBuilder(this.coordinateMap, this.referenceMap);
            EntityProjectionTransformer entityProjectionTransformer = new EntityProjectionTransformer(4326, this.srid);
            Consumer<Entity> entityHandler = coordinateMapBuilder.andThen(referenceMapBuilder).andThen(entityGeometryBuilder).andThen(entityProjectionTransformer);
            entities = entities.map(ConsumerUtils.consumeThenReturn(entityHandler));
        }
        return entities;
    }
}

