/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.stream;

import java.util.Spliterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.baremaps.stream.StreamException;

class BufferedSpliterator<T>
implements Spliterator<CompletableFuture<T>> {
    private final CompletionOrder completionOrder;
    private final Spliterator<CompletableFuture<T>> spliterator;
    private final int bufferSize;
    private final BlockingQueue<CompletableFuture<T>> buffer;
    private int pending = 0;

    public BufferedSpliterator(Spliterator<CompletableFuture<T>> spliterator, int bufferSize, CompletionOrder completionOrder) {
        this.spliterator = spliterator;
        this.bufferSize = bufferSize;
        this.buffer = new ArrayBlockingQueue<CompletableFuture<T>>(bufferSize);
        this.completionOrder = completionOrder;
    }

    @Override
    public boolean tryAdvance(Consumer<? super CompletableFuture<T>> action) {
        this.fillBuffer();
        if (this.pending == 0) {
            return false;
        }
        try {
            CompletableFuture<T> future = this.buffer.take();
            --this.pending;
            action.accept(future);
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new StreamException(e);
        }
    }

    @Override
    public Spliterator<CompletableFuture<T>> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        long estimate = (long)this.pending + this.spliterator.estimateSize();
        if (estimate < 0L) {
            return Long.MAX_VALUE;
        }
        return estimate;
    }

    @Override
    public int characteristics() {
        return this.spliterator.characteristics();
    }

    private void fillBuffer() {
        while (this.pending < this.bufferSize && this.spliterator.tryAdvance((? super T future) -> this.completionOrder.registerCompletion(future, this.buffer::add))) {
            ++this.pending;
        }
    }

    public static interface CompletionOrder {
        public <T> void registerCompletion(CompletableFuture<T> var1, Consumer<CompletableFuture<T>> var2);
    }

    static enum InSourceOrder implements CompletionOrder
    {
        INSTANCE;


        @Override
        public <T> void registerCompletion(CompletableFuture<T> future, Consumer<CompletableFuture<T>> resultConsumer) {
            resultConsumer.accept(future);
        }
    }

    static enum InCompletionOrder implements CompletionOrder
    {
        INSTANCE;


        @Override
        public <T> void registerCompletion(CompletableFuture<T> future, Consumer<CompletableFuture<T>> resultConsumer) {
            future.whenComplete((result, error) -> resultConsumer.accept(future));
        }
    }
}

