/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.ContextDataInjector;
import org.apache.logging.log4j.core.annotation.ConditionalOnPropertyKey;
import org.apache.logging.log4j.core.config.composite.MergeStrategy;
import org.apache.logging.log4j.core.impl.Log4jPropertyKey;
import org.apache.logging.log4j.core.impl.LogEventFactory;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.core.util.ShutdownCallbackRegistry;
import org.apache.logging.log4j.plugins.Factory;
import org.apache.logging.log4j.plugins.Inject;
import org.apache.logging.log4j.plugins.Named;
import org.apache.logging.log4j.plugins.Ordered;
import org.apache.logging.log4j.plugins.SingletonFactory;
import org.apache.logging.log4j.plugins.di.InjectException;
import org.apache.logging.log4j.plugins.di.InstanceFactory;
import org.apache.logging.log4j.util.PropertyEnvironment;
import org.apache.logging.log4j.util.PropertyKey;

public class SystemPropertyBundle {
    private final InstanceFactory instanceFactory;
    private final PropertyEnvironment properties;
    private final ClassLoader classLoader;

    @Inject
    public SystemPropertyBundle(InstanceFactory instanceFactory, PropertyEnvironment properties, ClassLoader classLoader) {
        this.instanceFactory = instanceFactory;
        this.properties = properties;
        this.classLoader = classLoader;
    }

    @ConditionalOnPropertyKey(key=Log4jPropertyKey.CONTEXT_SELECTOR_CLASS_NAME)
    @SingletonFactory
    public ContextSelector systemPropertyContextSelector() throws ClassNotFoundException {
        return this.newInstanceOfProperty(Log4jPropertyKey.CONTEXT_SELECTOR_CLASS_NAME, ContextSelector.class);
    }

    @ConditionalOnPropertyKey(key=Log4jPropertyKey.SHUTDOWN_CALLBACK_REGISTRY)
    @SingletonFactory
    @Ordered(value=100)
    public @Ordered(value=100) ShutdownCallbackRegistry systemPropertyShutdownCallbackRegistry() throws ClassNotFoundException {
        return this.newInstanceOfProperty(Log4jPropertyKey.SHUTDOWN_CALLBACK_REGISTRY, ShutdownCallbackRegistry.class);
    }

    @ConditionalOnPropertyKey(key=Log4jPropertyKey.THREAD_CONTEXT_DATA_INJECTOR_CLASS_NAME)
    @Factory
    public ContextDataInjector systemPropertyContextDataInjector() throws ClassNotFoundException {
        return this.newInstanceOfProperty(Log4jPropertyKey.THREAD_CONTEXT_DATA_INJECTOR_CLASS_NAME, ContextDataInjector.class);
    }

    @ConditionalOnPropertyKey(key=Log4jPropertyKey.LOG_EVENT_FACTORY_CLASS_NAME)
    @SingletonFactory
    public LogEventFactory systemPropertyLogEventFactory() throws ClassNotFoundException {
        return this.newInstanceOfProperty(Log4jPropertyKey.LOG_EVENT_FACTORY_CLASS_NAME, LogEventFactory.class);
    }

    @ConditionalOnPropertyKey(key=Log4jPropertyKey.CONFIG_MERGE_STRATEGY)
    @SingletonFactory
    public MergeStrategy systemPropertyMergeStrategy() throws ClassNotFoundException {
        return this.newInstanceOfProperty(Log4jPropertyKey.CONFIG_MERGE_STRATEGY, MergeStrategy.class);
    }

    @ConditionalOnPropertyKey(key=Log4jPropertyKey.STATUS_DEFAULT_LEVEL)
    @SingletonFactory
    @Named(value={"StatusLogger"})
    public @Named(value={"StatusLogger"}) Level systemPropertyDefaultStatusLevel() {
        return Level.getLevel((String)this.properties.getStringProperty((PropertyKey)Log4jPropertyKey.STATUS_DEFAULT_LEVEL));
    }

    private <T> T newInstanceOfProperty(PropertyKey propertyKey, Class<T> supertype) throws ClassNotFoundException {
        String property = this.properties.getStringProperty(propertyKey);
        if (property == null) {
            throw new InjectException("No property defined for name " + propertyKey.toString());
        }
        return (T)this.instanceFactory.getInstance(this.classLoader.loadClass(property).asSubclass(supertype));
    }
}

