/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web;

import com.google.common.collect.Maps;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.UserPrincipal;
import org.apache.gravitino.audit.FilesetDataOperation;
import org.apache.gravitino.audit.InternalClientType;
import org.apache.gravitino.auth.AuthConstants;
import org.apache.gravitino.dto.responses.ErrorResponse;
import org.apache.gravitino.utils.PrincipalUtils;

public class Utils {
    private static final String REMOTE_USER = "gravitino";

    private Utils() {
    }

    public static String remoteUser(HttpServletRequest httpRequest) {
        return Optional.ofNullable(httpRequest.getRemoteUser()).orElse(REMOTE_USER);
    }

    public static <T> Response ok(T t) {
        return Response.status((Response.Status)Response.Status.OK).entity(t).type("application/json").build();
    }

    public static Response ok() {
        return Response.status((Response.Status)Response.Status.NO_CONTENT).type("application/json").build();
    }

    public static Response illegalArguments(String message) {
        return Utils.illegalArguments(IllegalArgumentException.class.getSimpleName(), message, null);
    }

    public static Response illegalArguments(String message, Throwable throwable) {
        return Utils.illegalArguments(throwable.getClass().getSimpleName(), message, throwable);
    }

    public static Response illegalArguments(String type, String message, Throwable throwable) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorResponse.illegalArguments((String)type, (String)message, (Throwable)throwable)).type("application/json").build();
    }

    public static Response connectionFailed(String message) {
        return Response.status((Response.Status)Response.Status.BAD_GATEWAY).entity((Object)ErrorResponse.connectionFailed((String)message)).type("application/json").build();
    }

    public static Response connectionFailed(String message, Throwable throwable) {
        return Response.status((Response.Status)Response.Status.BAD_GATEWAY).entity((Object)ErrorResponse.connectionFailed((String)message, (Throwable)throwable)).type("application/json").build();
    }

    public static Response internalError(String message) {
        return Utils.internalError(message, null);
    }

    public static Response internalError(String message, Throwable throwable) {
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ErrorResponse.internalError((String)message, (Throwable)throwable)).type("application/json").build();
    }

    public static Response notFound(String type, String message) {
        return Utils.notFound(type, message, null);
    }

    public static Response notFound(String message, Throwable throwable) {
        return Utils.notFound(throwable.getClass().getSimpleName(), message, throwable);
    }

    public static Response notFound(String type, String message, Throwable throwable) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorResponse.notFound((String)type, (String)message, (Throwable)throwable)).type("application/json").build();
    }

    public static Response alreadyExists(String type, String message) {
        return Utils.alreadyExists(type, message, null);
    }

    public static Response alreadyExists(String message, Throwable throwable) {
        return Utils.alreadyExists(throwable.getClass().getSimpleName(), message, throwable);
    }

    public static Response alreadyExists(String type, String message, Throwable throwable) {
        return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)ErrorResponse.alreadyExists((String)type, (String)message, (Throwable)throwable)).type("application/json").build();
    }

    public static Response notInUse(String message, Throwable throwable) {
        return Utils.notInUse(throwable.getClass().getSimpleName(), message, throwable);
    }

    public static Response notInUse(String type, String message, Throwable throwable) {
        return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)ErrorResponse.notInUse((String)type, (String)message, (Throwable)throwable)).type("application/json").build();
    }

    public static Response inUse(String message, Throwable throwable) {
        return Utils.inUse(throwable.getClass().getSimpleName(), message, throwable);
    }

    public static Response inUse(String type, String message, Throwable throwable) {
        return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)ErrorResponse.inUse((String)type, (String)message, (Throwable)throwable)).type("application/json").build();
    }

    public static Response nonEmpty(String type, String message) {
        return Utils.nonEmpty(type, message, null);
    }

    public static Response nonEmpty(String message, Throwable throwable) {
        return Utils.nonEmpty(throwable.getClass().getSimpleName(), message, throwable);
    }

    public static Response nonEmpty(String type, String message, Throwable throwable) {
        return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)ErrorResponse.nonEmpty((String)type, (String)message, (Throwable)throwable)).type("application/json").build();
    }

    public static Response unsupportedOperation(String message) {
        return Utils.unsupportedOperation(message, null);
    }

    public static Response unsupportedOperation(String message, Throwable throwable) {
        return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)ErrorResponse.unsupportedOperation((String)message, (Throwable)throwable)).type("application/json").build();
    }

    public static Response forbidden(String message, Throwable throwable) {
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ErrorResponse.forbidden((String)message, (Throwable)throwable)).type("application/json").build();
    }

    public static Response doAs(HttpServletRequest httpRequest, PrivilegedExceptionAction<Response> action) throws Exception {
        UserPrincipal principal = (UserPrincipal)httpRequest.getAttribute(AuthConstants.AUTHENTICATED_PRINCIPAL_ATTRIBUTE_NAME);
        if (principal == null) {
            principal = new UserPrincipal("anonymous");
        }
        return (Response)PrincipalUtils.doAs((Principal)principal, action);
    }

    public static Map<String, String> filterFilesetAuditHeaders(HttpServletRequest httpRequest) {
        HashMap filteredHeaders = Maps.newHashMap();
        String internalClientType = httpRequest.getHeader("InternalClientType");
        if (StringUtils.isNotBlank((CharSequence)internalClientType)) {
            filteredHeaders.put("InternalClientType", InternalClientType.checkValid((String)internalClientType) ? internalClientType : InternalClientType.UNKNOWN.name());
        }
        String dataOperation = httpRequest.getHeader("FilesetDataOperation");
        if (StringUtils.isNotBlank((CharSequence)httpRequest.getHeader("FilesetDataOperation"))) {
            filteredHeaders.put("FilesetDataOperation", FilesetDataOperation.checkValid((String)dataOperation) ? dataOperation : FilesetDataOperation.UNKNOWN.name());
        }
        return filteredHeaders;
    }
}

