/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.catalog.TopicDispatcher;
import org.apache.gravitino.dto.requests.TopicCreateRequest;
import org.apache.gravitino.dto.requests.TopicUpdateRequest;
import org.apache.gravitino.dto.requests.TopicUpdatesRequest;
import org.apache.gravitino.dto.responses.DropResponse;
import org.apache.gravitino.dto.responses.EntityListResponse;
import org.apache.gravitino.dto.responses.TopicResponse;
import org.apache.gravitino.dto.util.DTOConverters;
import org.apache.gravitino.lock.LockType;
import org.apache.gravitino.lock.TreeLockUtils;
import org.apache.gravitino.messaging.Topic;
import org.apache.gravitino.messaging.TopicChange;
import org.apache.gravitino.server.web.Utils;
import org.apache.gravitino.server.web.rest.ExceptionHandlers;
import org.apache.gravitino.server.web.rest.OperationType;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.NamespaceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/metalakes/{metalake}/catalogs/{catalog}/schemas/{schema}/topics")
public class TopicOperations {
    private static final Logger LOG = LoggerFactory.getLogger(TopicOperations.class);
    private final TopicDispatcher dispatcher;
    @Context
    private HttpServletRequest httpRequest;

    @Inject
    public TopicOperations(TopicDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @GET
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="list-topic.http-request-duration-seconds", absolute=true)
    public Response listTopics(@PathParam(value="metalake") String metalake, @PathParam(value="catalog") String catalog, @PathParam(value="schema") String schema) {
        try {
            LOG.info("Received list topics request for schema: {}.{}.{}", new Object[]{metalake, catalog, schema});
            return Utils.doAs(this.httpRequest, () -> {
                LOG.info("Listing topics under schema: {}.{}.{}", new Object[]{metalake, catalog, schema});
                Namespace topicNS = NamespaceUtil.ofTopic((String)metalake, (String)catalog, (String)schema);
                NameIdentifier[] topics = (NameIdentifier[])TreeLockUtils.doWithTreeLock((NameIdentifier)NameIdentifier.of((String[])new String[]{metalake, catalog, schema}), (LockType)LockType.READ, () -> this.dispatcher.listTopics(topicNS));
                Response response = Utils.ok(new EntityListResponse(topics));
                LOG.info("List {} topics under schema: {}.{}.{}", new Object[]{topics.length, metalake, catalog, schema});
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleFilesetException(OperationType.LIST, "", schema, e);
        }
    }

    @POST
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="create-topic.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="create-topic", absolute=true)
    public Response createTopic(@PathParam(value="metalake") String metalake, @PathParam(value="catalog") String catalog, @PathParam(value="schema") String schema, TopicCreateRequest request) {
        LOG.info("Received create topic request: {}.{}.{}", new Object[]{metalake, catalog, schema});
        try {
            return Utils.doAs(this.httpRequest, () -> {
                LOG.info("Creating topic under schema: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, request.getName()});
                request.validate();
                NameIdentifier ident = NameIdentifierUtil.ofTopic((String)metalake, (String)catalog, (String)schema, (String)request.getName());
                Topic topic = this.dispatcher.createTopic(ident, request.getComment(), null, request.getProperties());
                Response response = Utils.ok(new TopicResponse(DTOConverters.toDTO((Topic)topic)));
                LOG.info("Topic created: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, topic.name()});
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleTopicException(OperationType.CREATE, request.getName(), schema, e);
        }
    }

    @GET
    @Path(value="/{topic}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="load-topic.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="load-topic", absolute=true)
    public Response loadTopic(@PathParam(value="metalake") String metalake, @PathParam(value="catalog") String catalog, @PathParam(value="schema") String schema, @PathParam(value="topic") String topic) {
        LOG.info("Received load topic request for topic: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, topic});
        try {
            return Utils.doAs(this.httpRequest, () -> {
                LOG.info("Loading topic: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, topic});
                NameIdentifier ident = NameIdentifierUtil.ofTopic((String)metalake, (String)catalog, (String)schema, (String)topic);
                Topic t = this.dispatcher.loadTopic(ident);
                Response response = Utils.ok(new TopicResponse(DTOConverters.toDTO((Topic)t)));
                LOG.info("Topic loaded: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, topic});
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleTopicException(OperationType.LOAD, topic, schema, e);
        }
    }

    @PUT
    @Path(value="/{topic}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="alter-topic.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="alter-topic", absolute=true)
    public Response alterTopic(@PathParam(value="metalake") String metalake, @PathParam(value="catalog") String catalog, @PathParam(value="schema") String schema, @PathParam(value="topic") String topic, TopicUpdatesRequest request) {
        LOG.info("Received alter topic request: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, topic});
        try {
            return Utils.doAs(this.httpRequest, () -> {
                LOG.info("Altering topic: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, topic});
                request.validate();
                NameIdentifier ident = NameIdentifierUtil.ofTopic((String)metalake, (String)catalog, (String)schema, (String)topic);
                TopicChange[] changes = (TopicChange[])request.getUpdates().stream().map(TopicUpdateRequest::topicChange).toArray(TopicChange[]::new);
                Topic t = (Topic)TreeLockUtils.doWithTreeLock((NameIdentifier)NameIdentifierUtil.ofSchema((String)metalake, (String)catalog, (String)schema), (LockType)LockType.WRITE, () -> this.dispatcher.alterTopic(ident, changes));
                Response response = Utils.ok(new TopicResponse(DTOConverters.toDTO((Topic)t)));
                LOG.info("Topic altered: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, t.name()});
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleTopicException(OperationType.ALTER, topic, schema, e);
        }
    }

    @DELETE
    @Path(value="/{topic}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="drop-topic.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="drop-topic", absolute=true)
    public Response dropTopic(@PathParam(value="metalake") String metalake, @PathParam(value="catalog") String catalog, @PathParam(value="schema") String schema, @PathParam(value="topic") String topic) {
        LOG.info("Received drop topic request: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, topic});
        try {
            return Utils.doAs(this.httpRequest, () -> {
                LOG.info("Dropping topic under schema: {}.{}.{}", new Object[]{metalake, catalog, schema});
                NameIdentifier ident = NameIdentifierUtil.ofTopic((String)metalake, (String)catalog, (String)schema, (String)topic);
                boolean dropped = (Boolean)TreeLockUtils.doWithTreeLock((NameIdentifier)NameIdentifierUtil.ofSchema((String)metalake, (String)catalog, (String)schema), (LockType)LockType.WRITE, () -> this.dispatcher.dropTopic(ident));
                if (!dropped) {
                    LOG.warn("Failed to drop topic {} under schema {}", (Object)topic, (Object)schema);
                }
                Response response = Utils.ok(new DropResponse(dropped));
                LOG.info("Topic dropped: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, topic});
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleTopicException(OperationType.DROP, topic, schema, e);
        }
    }
}

