/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import org.apache.paimon.casting.AbstractCastRule;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastRulePredicate;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeFamily;
import org.apache.paimon.utils.BinaryStringUtils;

class StringToBinaryCastRule
extends AbstractCastRule<BinaryString, byte[]> {
    static final StringToBinaryCastRule INSTANCE = new StringToBinaryCastRule();

    private StringToBinaryCastRule() {
        super(CastRulePredicate.builder().input(DataTypeFamily.CHARACTER_STRING).target(DataTypeFamily.BINARY_STRING).build());
    }

    @Override
    public CastExecutor<BinaryString, byte[]> create(DataType inputType, DataType targetType) {
        return value -> BinaryStringUtils.toBinaryString((byte[])value.toBytes(), (DataType)targetType);
    }
}

