/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization.common;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.authorization.AuthorizationMetadataObject;

public class PathBasedMetadataObject
implements AuthorizationMetadataObject {
    private final String name;
    private final String parent;
    private final String path;
    private final AuthorizationMetadataObject.Type type;

    public PathBasedMetadataObject(String parent, String name, String path, AuthorizationMetadataObject.Type type) {
        this.parent = parent;
        this.name = name;
        this.path = path;
        this.type = type;
    }

    public String name() {
        return this.name;
    }

    public List<String> names() {
        return DOT_SPLITTER.splitToList((CharSequence)this.fullName());
    }

    public String parent() {
        return this.parent;
    }

    public String path() {
        return this.path;
    }

    public AuthorizationMetadataObject.Type type() {
        return this.type;
    }

    public void validateAuthorizationMetadataObject() throws IllegalArgumentException {
        List<String> names = this.names();
        Preconditions.checkArgument((names != null && !names.isEmpty() ? 1 : 0) != 0, (Object)"Cannot create a path based metadata object with no names");
        Preconditions.checkArgument((this.path != null && !this.path.isEmpty() ? 1 : 0) != 0, (Object)"Cannot create a path based metadata object with no path");
        Preconditions.checkArgument((this.type == Type.PATH ? 1 : 0) != 0, (Object)"it must be the PATH type");
        for (String name : names) {
            Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Cannot create a path based metadata object with null name");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PathBasedMetadataObject)) {
            return false;
        }
        PathBasedMetadataObject that = (PathBasedMetadataObject)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.parent, that.parent) && Objects.equals(this.path, that.path) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.parent, this.path, this.type);
    }

    public String toString() {
        return "MetadataObject: [fullName=" + this.fullName() + "],  [path=" + this.path == null ? "null" : this.path + "], [type=" + this.type + "]";
    }

    public static enum Type implements AuthorizationMetadataObject.Type
    {
        PATH(MetadataObject.Type.FILESET);

        private final MetadataObject.Type metadataType;

        private Type(MetadataObject.Type type) {
            this.metadataType = type;
        }

        public MetadataObject.Type metadataObjectType() {
            return this.metadataType;
        }
    }
}

