/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import org.apache.gravitino.Config;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityAlreadyExistsException;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.SupportsRelationOperations;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.tag.SupportsTagOperations;
import org.apache.gravitino.utils.Executable;

public interface EntityStore
extends Closeable {
    public void initialize(Config var1) throws RuntimeException;

    default public <E extends Entity & HasIdentifier> List<E> list(Namespace namespace, Class<E> type, Entity.EntityType entityType) throws IOException {
        return this.list(namespace, type, entityType, true);
    }

    default public <E extends Entity & HasIdentifier> List<E> list(Namespace namespace, Class<E> type, Entity.EntityType entityType, boolean allFields) throws IOException {
        throw new UnsupportedOperationException("Don't support to skip fields");
    }

    public boolean exists(NameIdentifier var1, Entity.EntityType var2) throws IOException;

    default public <E extends Entity & HasIdentifier> void put(E e) throws IOException {
        this.put(e, false);
    }

    public <E extends Entity & HasIdentifier> void put(E var1, boolean var2) throws IOException, EntityAlreadyExistsException;

    public <E extends Entity & HasIdentifier> E update(NameIdentifier var1, Class<E> var2, Entity.EntityType var3, Function<E, E> var4) throws IOException, NoSuchEntityException, EntityAlreadyExistsException;

    public <E extends Entity & HasIdentifier> E get(NameIdentifier var1, Entity.EntityType var2, Class<E> var3) throws NoSuchEntityException, IOException;

    default public boolean delete(NameIdentifier ident, Entity.EntityType entityType) throws IOException {
        return this.delete(ident, entityType, false);
    }

    public boolean delete(NameIdentifier var1, Entity.EntityType var2, boolean var3) throws IOException;

    public <R, E extends Exception> R executeInTransaction(Executable<R, E> var1) throws E, IOException;

    default public SupportsTagOperations tagOperations() {
        throw new UnsupportedOperationException("tag operations are not supported");
    }

    default public SupportsRelationOperations relationOperations() {
        throw new UnsupportedOperationException("relation operations are not supported");
    }
}

