/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.apache.iceberg.BaseFileScanTask;
import org.apache.iceberg.ContentFileParser;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionParser;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.expressions.True;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.util.JsonUtil;

public class FileScanTaskParser {
    private static final String SCHEMA = "schema";
    private static final String SPEC = "spec";
    private static final String DATA_FILE = "data-file";
    private static final String START = "start";
    private static final String LENGTH = "length";
    private static final String DELETE_FILES = "delete-files";
    private static final String RESIDUAL = "residual-filter";

    private FileScanTaskParser() {
    }

    public static String toJson(FileScanTask fileScanTask) {
        return JsonUtil.generate(generator -> FileScanTaskParser.toJson(fileScanTask, generator), false);
    }

    private static void toJson(FileScanTask fileScanTask, JsonGenerator generator) throws IOException {
        Preconditions.checkArgument((fileScanTask != null ? 1 : 0) != 0, (Object)"Invalid file scan task: null");
        Preconditions.checkArgument((generator != null ? 1 : 0) != 0, (Object)"Invalid JSON generator: null");
        generator.writeStartObject();
        generator.writeFieldName(SCHEMA);
        SchemaParser.toJson(fileScanTask.schema(), generator);
        generator.writeFieldName(SPEC);
        PartitionSpec spec = fileScanTask.spec();
        PartitionSpecParser.toJson(spec, generator);
        if (fileScanTask.file() != null) {
            generator.writeFieldName(DATA_FILE);
            ContentFileParser.toJson(fileScanTask.file(), spec, generator);
        }
        generator.writeNumberField(START, fileScanTask.start());
        generator.writeNumberField(LENGTH, fileScanTask.length());
        if (fileScanTask.deletes() != null) {
            generator.writeArrayFieldStart(DELETE_FILES);
            for (DeleteFile deleteFile : fileScanTask.deletes()) {
                ContentFileParser.toJson(deleteFile, spec, generator);
            }
            generator.writeEndArray();
        }
        if (fileScanTask.residual() != null) {
            generator.writeFieldName(RESIDUAL);
            ExpressionParser.toJson(fileScanTask.residual(), generator);
        }
        generator.writeEndObject();
    }

    public static FileScanTask fromJson(String json, boolean caseSensitive) {
        Preconditions.checkArgument((json != null ? 1 : 0) != 0, (Object)"Invalid JSON string for file scan task: null");
        return JsonUtil.parse(json, node -> FileScanTaskParser.fromJson(node, caseSensitive));
    }

    private static FileScanTask fromJson(JsonNode jsonNode, boolean caseSensitive) {
        Preconditions.checkArgument((jsonNode != null ? 1 : 0) != 0, (Object)"Invalid JSON node for file scan task: null");
        Preconditions.checkArgument((boolean)jsonNode.isObject(), (String)"Invalid JSON node for file scan task: non-object (%s)", (Object)jsonNode);
        Schema schema = SchemaParser.fromJson(JsonUtil.get(SCHEMA, jsonNode));
        String schemaString = SchemaParser.toJson(schema);
        PartitionSpec spec = PartitionSpecParser.fromJson(schema, JsonUtil.get(SPEC, jsonNode));
        String specString = PartitionSpecParser.toJson(spec);
        DataFile dataFile = null;
        if (jsonNode.has(DATA_FILE)) {
            dataFile = (DataFile)ContentFileParser.fromJson(jsonNode.get(DATA_FILE), spec);
        }
        long start = JsonUtil.getLong(START, jsonNode);
        long length = JsonUtil.getLong(LENGTH, jsonNode);
        DeleteFile[] deleteFiles = null;
        if (jsonNode.has(DELETE_FILES)) {
            JsonNode deletesArray = jsonNode.get(DELETE_FILES);
            Preconditions.checkArgument((boolean)deletesArray.isArray(), (String)"Invalid JSON node for delete files: non-array (%s)", (Object)deletesArray);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JsonNode deleteFileNode : deletesArray) {
                DeleteFile deleteFile = (DeleteFile)ContentFileParser.fromJson(deleteFileNode, spec);
                builder.add((Object)deleteFile);
            }
            deleteFiles = (DeleteFile[])builder.build().toArray((Object[])new DeleteFile[0]);
        }
        True filter = Expressions.alwaysTrue();
        if (jsonNode.has(RESIDUAL)) {
            filter = ExpressionParser.fromJson(jsonNode.get(RESIDUAL));
        }
        ResidualEvaluator residualEvaluator = ResidualEvaluator.of((PartitionSpec)spec, (Expression)filter, (boolean)caseSensitive);
        BaseFileScanTask baseFileScanTask = new BaseFileScanTask(dataFile, deleteFiles, schemaString, specString, residualEvaluator);
        return new BaseFileScanTask.SplitScanTask(start, length, baseFileScanTask);
    }
}

