/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.hook;

import java.util.List;
import java.util.Map;
import org.apache.gravitino.Entity;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.authorization.AuthorizationUtils;
import org.apache.gravitino.authorization.Owner;
import org.apache.gravitino.authorization.OwnerManager;
import org.apache.gravitino.catalog.FilesetDispatcher;
import org.apache.gravitino.exceptions.FilesetAlreadyExistsException;
import org.apache.gravitino.exceptions.NoSuchFilesetException;
import org.apache.gravitino.exceptions.NoSuchLocationNameException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.file.Fileset;
import org.apache.gravitino.file.FilesetChange;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.PrincipalUtils;

public class FilesetHookDispatcher
implements FilesetDispatcher {
    private final FilesetDispatcher dispatcher;

    public FilesetHookDispatcher(FilesetDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public NameIdentifier[] listFilesets(Namespace namespace) throws NoSuchSchemaException {
        return this.dispatcher.listFilesets(namespace);
    }

    public Fileset loadFileset(NameIdentifier ident) throws NoSuchFilesetException {
        return this.dispatcher.loadFileset(ident);
    }

    public Fileset createMultipleLocationFileset(NameIdentifier ident, String comment, Fileset.Type type, Map<String, String> storageLocations, Map<String, String> properties) throws NoSuchSchemaException, FilesetAlreadyExistsException {
        AuthorizationUtils.checkCurrentUser(ident.namespace().level(0), PrincipalUtils.getCurrentUserName());
        Fileset fileset = this.dispatcher.createMultipleLocationFileset(ident, comment, type, storageLocations, properties);
        OwnerManager ownerManager = GravitinoEnv.getInstance().ownerManager();
        if (ownerManager != null) {
            ownerManager.setOwner(ident.namespace().level(0), NameIdentifierUtil.toMetadataObject(ident, Entity.EntityType.FILESET), PrincipalUtils.getCurrentUserName(), Owner.Type.USER);
        }
        return fileset;
    }

    public Fileset alterFileset(NameIdentifier ident, FilesetChange ... changes) throws NoSuchFilesetException, IllegalArgumentException {
        Fileset alteredFileset = this.dispatcher.alterFileset(ident, changes);
        FilesetChange.RenameFileset lastRenameChange = null;
        for (FilesetChange change : changes) {
            if (!(change instanceof FilesetChange.RenameFileset)) continue;
            lastRenameChange = (FilesetChange.RenameFileset)change;
        }
        if (lastRenameChange != null) {
            AuthorizationUtils.authorizationPluginRenamePrivileges(ident, Entity.EntityType.FILESET, lastRenameChange.getNewName());
        }
        return alteredFileset;
    }

    public boolean dropFileset(NameIdentifier ident) {
        List<String> locations = AuthorizationUtils.getMetadataObjectLocation(ident, Entity.EntityType.FILESET);
        boolean dropped = this.dispatcher.dropFileset(ident);
        AuthorizationUtils.authorizationPluginRemovePrivileges(ident, Entity.EntityType.FILESET, locations);
        return dropped;
    }

    public boolean filesetExists(NameIdentifier ident) {
        return this.dispatcher.filesetExists(ident);
    }

    public String getFileLocation(NameIdentifier ident, String subPath, String locationName) throws NoSuchFilesetException, NoSuchLocationNameException {
        return this.dispatcher.getFileLocation(ident, subPath, locationName);
    }
}

