/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.parquet.crypto;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.paimon.shade.org.apache.parquet.crypto.FileEncryptionProperties;
import org.apache.paimon.shade.org.apache.parquet.crypto.ParquetCryptoRuntimeException;
import org.apache.paimon.shade.org.apache.parquet.hadoop.BadConfigurationException;
import org.apache.paimon.shade.org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.paimon.shade.org.apache.parquet.hadoop.util.ConfigurationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface EncryptionPropertiesFactory {
    public static final Logger LOG = LoggerFactory.getLogger(EncryptionPropertiesFactory.class);
    public static final String CRYPTO_FACTORY_CLASS_PROPERTY_NAME = "parquet.crypto.factory.class";

    public static EncryptionPropertiesFactory loadFactory(Configuration conf) {
        Class<?> encryptionPropertiesFactoryClass = ConfigurationUtil.getClassFromConfig(conf, CRYPTO_FACTORY_CLASS_PROPERTY_NAME, EncryptionPropertiesFactory.class);
        if (null == encryptionPropertiesFactoryClass) {
            LOG.debug("EncryptionPropertiesFactory is not configured - name not found in hadoop config");
            return null;
        }
        try {
            return (EncryptionPropertiesFactory)encryptionPropertiesFactoryClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new BadConfigurationException("could not instantiate encryptionPropertiesFactoryClass class: " + encryptionPropertiesFactoryClass, e);
        }
    }

    public FileEncryptionProperties getFileEncryptionProperties(Configuration var1, Path var2, WriteSupport.WriteContext var3) throws ParquetCryptoRuntimeException;
}

